<?php

class Zend_View_Helper_Message
{
	public $msg_ok 		= "";
	public $msg_error 	= "";
	protected $style 	= "default";
	protected $view;
	protected $directory;	
	
	public function message() {
		$this->initialize();
		return $this;
	}
	
	public function getMessage($style = null) {
		$style = (isset($style)) ? $style : $this->style;
		
		$view = new Zend_View();
	    $view->addScriptPath($this->directory);	    
	    $view->assign((array) get_object_vars($this));
	    
	    return $view->render($style.'.phtml');
	}
	
	private function initialize() {
		$this->msg_ok 	 = Neikos_Systemmessage::getAll(Neikos_Systemmessage::MSG_OK);
		$this->msg_error = Neikos_Systemmessage::getAll(Neikos_Systemmessage::MSG_ERRORE);
		$this->directory = dirname(__FILE__).'/message/';
	}
	
	/**
	 * Setta la vista corrente...
	 *
	 * @param Zend_View_Interface $view
	 */
	public function setView(Zend_View_Interface $view)
	{
		$this->view = $view;
	}
}

?>