document.observe("dom:loaded", function() {
	$A($$("#lista_database_user input.input_nascosto[ref=pw]")).each(
		function (item) {
			item.readOnly = true;
			item.observe("mouseover", function (event) {
					if ($F("associaP") == "A") {
						var element = event.element();
						element.addClassName("input_attivo");
						element.readOnly = false;
					}
				}
			);

			item.observe("mouseout", function (event){
					var element = event.element();
					element.removeClassName("input_attivo");
					element.readOnly = true;
			  }
			);

			item.observe("focus", function (event){
					if ($F("associaP") == "A") {
						var element = event.element();
						element.addClassName("input_attivo_on");
						element.readOnly = false;
					}
			  }
			);

			item.observe("blur", function (event){
						var element = event.element();
						element.removeClassName("input_attivo_on");
						element.readOnly = true;

						var mods = element.readAttribute("mods");
						var defvalue = element.readAttribute("defvalue")

						if (parseInt(mods) == 1) {
							element.writeAttribute("mods", 0)
							element.value = defvalue;
						}

						// Aggiorna la password sul server:
						salvaPw(element);
				  }
			);
		}
	);

	// Carica la lista dei db solo in funzione del server scelto:
	Element.observe($("server_id"), "change", function() {
		var server_id = $("server_id").getValue();

		new Ajax.Updater("filtroRicercaDb", "/database/ajax-get-filtro-ricerca-db/", {
			method: "post",
			postBody: "server_id=" + parseInt(server_id)
		});
	});
});

function salvaPw(inputElement) {
	var database_user_id = inputElement.readAttribute("database_user_id");
	var defValue = inputElement.readAttribute("defvalue");
	var pw = inputElement.getValue();

	// Url e corpo del POST:
	var url = "/database/ajax-save-user-pw";
	var postQueryString = "database_user_id=" + parseInt(database_user_id) + "&pw=" + encodeURIComponent(pw);

	if (pw != defValue) {
	 	$("div_loading").show();

		// Richiesta AJAX:
		new Ajax.Request(url, {
				method: 'post',
			    postBody: postQueryString,
			    onFailure: function() {
			    	// Qualcosa è andato storto, quindi ripristina i valori precedenti:
	                var defvalue = inputElement.readAttribute("defvalue")
					inputElement.writeAttribute("mods", 0)
					inputElement.setValue(defvalue);

					// Mostra il msg di errore:
	                alert("Il salvataggio non e' riuscito... Si prega di ricaricare la pagina e riprovare.");
			    },
			    onSuccess: function(transport) {
					inputElement.writeAttribute("mods", 0);
	               	inputElement.writeAttribute("defvalue", inputElement.getValue());

					// Mostra un msg per maggiore sicurezza:
	               	// alert("Salvataggio effettuato!");
	           },
	           onComplete: function() {
	        	   // Nasconde il div del caricamento:
	        	   $("div_loading").hide();
	           }
	    });
	}
}

function switchUserNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var display = nota.style.display;
		if (display == "none") {
			// Se era già stata richiamata la mostra soltanto:
			if (nota.innerHTML != "") {
				nota.style.display = "block";
			} else {
				// altrimenti la richiama con ajax:
				new Ajax.Updater("nota_" + id, "/database/loadnote-user/database_user_id/" + id, {
					onComplete: function(){
						nota.style.display = "block";
					}
				});
			}
		} else {
			nota.style.display = "none";
		}
	}
}

function saveUserNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var url = "/database/savenote-user/database_user_id/" + id;

		// Mostra il loading:
		$("nota_loading_" + id).show();

		// Testo della nota:
		var testoNota = $F("testo_nota_" + id);

		new Ajax.Request(url, {
		  	method: 'post',
			postBody: 'note=' + encodeURIComponent(testoNota),
		  	onSuccess: function(transport) {
		    		    if (transport.responseText != 1) {
		                    alert("Il salvataggio non &egrave; riuscito... Si prega di ricaricare la pagina e riprovare.");
		                } else {
					   		var img = $("img_nota_" + id);
					   		if (testoNota != "") {
								img.writeAttribute("src", "/images/notaon.gif");
							} else {
								img.writeAttribute("src", "/images/notaoff.gif");
							}
					    }

					   	// Nasconde il loading:
		               	$("nota_loading_" + id).hide();
		  	}
		});
	}
}