document.observe("dom:loaded", function() {
	$A($$("#lista_database input.input_nascosto[ref=clients]")).each(
		function (item) {
			item.readOnly = true;
			new Ajax.Autocompleter(item, "autocomplete", "/utility/autocomplete-clients", {paramName:"q", minChars:2, afterUpdateElement:salvaCliente});

			item.observe("mouseover", function (event){
											if ($F("associaC") == "A") {
												var element = event.element();
												element.addClassName("input_attivo");
												element.readOnly = false;
											}
									  }
						);
			item.observe("mouseout", function (event){
											var element = event.element();
											element.removeClassName("input_attivo");
											element.readOnly = true;
									  }
						);

			item.observe("focus", function (event){
											if ($F("associaC") == "A") {
												var element = event.element();
												element.addClassName("input_attivo_on");
												element.readOnly = false;
											}
									  }
						);
			item.observe("blur", function (event){
											var element = event.element();
											element.removeClassName("input_attivo_on");
											element.readOnly = true;

											var mods = element.readAttribute("mods");
											var defvalue = element.readAttribute("defvalue")

											if (parseInt(mods) == 1) {
												element.writeAttribute("mods", 0)
												element.value = defvalue;
											}
									  }
						);
			item.observe("change", function (event) {
											var element = event.element();
											element.writeAttribute("mods", 1);
										}
			);
		}
	);


	$A($$("#lista_database input.input_nascosto[ref=software]")).each(
			function (item) {
				item.readOnly = true;
				new Ajax.Autocompleter(item, "autocomplete", "/utility/autocomplete-software", {paramName:"q", minChars:2, afterUpdateElement:salvaSoftware});

				item.observe("mouseover", function (event){
												if ($F("associaS") == "A") {
													var element = event.element();
													element.addClassName("input_attivo");
													element.readOnly = false;
												}
										  }
							);
				item.observe("mouseout", function (event){
												var element = event.element();
												element.removeClassName("input_attivo");
												element.readOnly = true;
										  }
							);

				item.observe("focus", function (event){
												if ($F("associaS") == "A") {
													var element = event.element();
													element.addClassName("input_attivo_on");
													element.readOnly = false;
												}
										  }
							);
				item.observe("blur", function (event){
												var element = event.element();
												element.removeClassName("input_attivo_on");
												element.readOnly = true;

												var mods = element.readAttribute("mods");
												var defvalue = element.readAttribute("defvalue")

												if (parseInt(mods) == 1) {
													element.writeAttribute("mods", 0)
													element.value = defvalue;
												}
										  }
							);
				item.observe("change", function (event) {
												var element = event.element();
												element.writeAttribute("mods", 1);
											}
				);
			}
		);
});

// Salva l'associazione tra cliente e database:
function salvaCliente(inputElement, client) {
	var database_id = inputElement.readAttribute("database_id");
	var client_id = client.id;

	// Url e corpo del POST:
	var url = "/database/saveclients";
	var postQueryString = "database_id=" + encodeURIComponent(database_id) + "&client_id=" + encodeURIComponent(client_id);

 	$("div_loading").show();

	// Richiesta AJAX:
	new Ajax.Request(url, {
				method: 'post',
			    postBody: postQueryString,
			    onSuccess: function(transport) {
								if (transport.responseText != 1) {
				                    // Qualcosa è andato storto:

				                    // Ripristina i valori precedenti:
				                    var defvalue = inputElement.readAttribute("defvalue")
									inputElement.writeAttribute("mods", 0)
									inputElement.value = defvalue;

									// Mostra il msg di errore:
				                    alert("Il salvataggio non e' riuscito... Si prega di ricaricare la pagina e riprovare.");
				               } else {
				               		inputElement.writeAttribute("mods", 0);
				               		inputElement.writeAttribute("defvalue", inputElement.value);
									var parent_id = inputElement.readAttribute("database_id");

									// Mostra un msg per maggiore sicurezza:
									alert("Salvataggio effettuato!");
				               }
				               $("div_loading").hide();
				           }
			    });
}


//Salva l'associazione tra cliente e software:
function salvaSoftware(inputElement, software) {
	var database_id = inputElement.readAttribute("database_id");
	var software_id = software.id;

	// Url e corpo del POST:
	var url = "/database/savesoftware";
	var postQueryString = "database_id=" + encodeURIComponent(database_id) + "&software_id=" + encodeURIComponent(software_id);

 	$("div_loading").show();

	// Richiesta AJAX:
	new Ajax.Request(url, {
				method: 'post',
			    postBody: postQueryString,
			    onFailure: function() {
			    	// Qualcosa è andato storto, quindi ripristina i valori precedenti:
                    var defvalue = inputElement.readAttribute("defvalue")
					inputElement.writeAttribute("mods", 0)
					inputElement.value = defvalue;

					// Mostra il msg di errore:
                    alert("Il salvataggio non e' riuscito... Si prega di ricaricare la pagina e riprovare.");
			    },
			    onSuccess: function(transport) {
               		inputElement.writeAttribute("mods", 0);
               		inputElement.writeAttribute("defvalue", inputElement.value);
					var parent_id = inputElement.readAttribute("database_id");

					// Mostra un msg per maggiore sicurezza:
					alert("Salvataggio effettuato!");
				},
				onComplete: function() {
					// Nasconde il div del caricamento in corso:
					$("div_loading").hide();
				}
	});
}

function switchNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var display = nota.style.display;
		if (display == "none") {
			// Se era già stata richiamata la mostra soltanto:
			if (nota.innerHTML != "") {
				nota.style.display = "block";
			} else {
				// altrimenti la richiama con ajax:
				new Ajax.Updater("nota_" + id, "/database/loadnote/database_id/" + id, {
					onComplete: function(){
						nota.style.display = "block";
					}
				});
			}
		} else {
			nota.style.display = "none";
		}
	}
}

function saveNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var url = "/database/savenote/database_id/" + id;

		// Mostra il loading:
		$("nota_loading_" + id).show();

		// Testo della nota:
		var testoNota = $F("testo_nota_" + id);

		new Ajax.Request(url, {
		  	method: 'post',
			postBody: 'note=' + encodeURIComponent(testoNota),
			onFailure: function() {
				alert("Il salvataggio non &egrave; riuscito... Si prega di ricaricare la pagina e riprovare.");
			},
		  	onSuccess: function(transport) {
		    	var img = $("img_nota_" + id);
		   		if (testoNota != "") {
					img.writeAttribute("src", "/images/notaon.gif");
				} else {
					img.writeAttribute("src", "/images/notaoff.gif");
				}
		  	},
		  	onComplete: function() {
		  		// Nasconde il loading:
               	$("nota_loading_" + id).hide();
		  	}
		});
	}
}


function switchDbUser(id) {
	id = parseInt(id);

	var dbUser = $("db_user_" + id);
	if (dbUser != null) {
		var display = dbUser.style.display;
		if (display == "none") {
			if (dbUser.innerHTML != "") {
				dbUser.style.display = "block";
			} else {
				new Ajax.Updater("db_user_" + id, "/database/show-user-details/database_id/" + id, {
					onComplete: function(){
						dbUser.style.display = "block";
					}
				});
			}
		} else {
			dbUser.style.display = "none";
		}
	}
}
