window.onload = function() {
	$A($$("#lista_domini input.input_nascosto")).each(
		function (item) {
			item.addClassName("input_nascosto");
			item.readOnly = true;
			new Ajax.Autocompleter(item, "autocomplete", "/utility/autocomplete-clients", {paramName:"q", minChars:2, afterUpdateElement:salvaCliente});

			item.observe("mouseover", function (event){
											if ($F("associaC") == "A") {
												var element = event.element();
												element.addClassName("input_attivo");
												element.readOnly = false;
											}
									  }
						);
			item.observe("mouseout", function (event){
											var element = event.element();
											element.removeClassName("input_attivo");
											element.readOnly = true;
									  }
						);

			item.observe("focus", function (event){
											if ($F("associaC") == "A") {
												var element = event.element();
												element.addClassName("input_attivo_on");
												element.readOnly = false;
											}
									  }
						);
			item.observe("blur", function (event){
											var element = event.element();
											element.removeClassName("input_attivo_on");
											element.readOnly = true;

											var mods = element.readAttribute("mods");
											var defvalue = element.readAttribute("defvalue")

											if (parseInt(mods) == 1) {
												element.writeAttribute("mods", 0)
												element.value = defvalue;
											}
									  }
						);
			item.observe("change", function (event) {
											var element = event.element();
											element.writeAttribute("mods", 1);
										}
			);
		}
	);
}

// Salva l'associazione tra cliente e dominio:
function salvaCliente(inputElement, client) {
	var domain_id = inputElement.readAttribute("domain_id");
	var client_id = client.id;

	// Url e corpo del POST:
	var url = "/domains/saveclients";
	var postQueryString = "domain_id=" + encodeURIComponent(domain_id) + "&client_id=" + encodeURIComponent(client_id);

 	$("div_loading").show();

	// Richiesta AJAX:
	new Ajax.Request(url, {
				method: 'post',
			    postBody: postQueryString,
			    onSuccess: function(transport) {
								if (transport.responseText != 1) {
				                    // Qualcosa � andato storto:

				                    // Ripristina i valori precedenti:
				                    var defvalue = element.readAttribute("defvalue")
									inputElement.writeAttribute("mods", 0)
									inputElement.value = defvalue;

									// Mostra il msg di errore:
				                    alert("Il salvataggio non � riuscito... Si prega di ricaricare la pagina e riprovare.");
				               } else {
				               		inputElement.writeAttribute("mods", 0);
				               		inputElement.writeAttribute("defvalue", inputElement.value);
									var parent_id = inputElement.readAttribute("domain_id");

									// Modifica anche il valore degli domini alias:
									$A($$("[parent_id=" + parent_id + "]")).each(
										function (item) {
											item.value = inputElement.value;
										}
									);

									// Mostra un msg per maggiore sicurezza:
									alert("Salvataggio effettuato!");
				               }
				               $("div_loading").hide();
				           }
			    });
}


function switchNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var display = nota.style.display;
		if (display == "none") {
			// Se era gi� stata richiamata la mostra soltanto:
			if (nota.innerHTML != "") {
				nota.style.display = "block";
			} else {
				// altrimenti la richiama con ajax:
				new Ajax.Updater("nota_" + id, "/domains/loadnote/domain_id/" + id, {
					onComplete: function(){
						nota.style.display = "block";
					}
				});
			}
		} else {
			nota.style.display = "none";
		}
	}
}

function saveNote(id) {
	id = parseInt(id);

	var nota = $("nota_" + id);
	if (nota != null) {
		var url = "/domains/savenote/domain_id/" + id;

		// Mostra il loading:
		$("nota_loading_" + id).show();

		// Testo della nota:
		var testoNota = $F("testo_nota_" + id);

		new Ajax.Request(url, {
		  	method: 'post',
			postBody: 'note=' + encodeURIComponent(testoNota),
		  	onSuccess: function(transport) {
		    		    if (transport.responseText != 1) {
		                    alert("Il salvataggio non &egrave; riuscito... Si prega di ricaricare la pagina e riprovare.");
		                } else {
					   		var img = $("img_nota_" + id);
					   		if (testoNota != "") {
								img.writeAttribute("src", "/images/notaon.gif");
							} else {
								img.writeAttribute("src", "/images/notaoff.gif");
							}
					    }

					   	// Nasconde il loading:
		               	$("nota_loading_" + id).hide();
		  	}
		});
	}
}

function toWarning(id) {
	id = parseInt(id);

	var url = "/domains/towarning/domain_id/" + id;
	new Ajax.Request(url, {
		onSuccess: function(transport) {
		    		    if (transport.responseText != 1) {
		                    alert("Il salvataggio non &egrave; riuscito... Si prega di ricaricare la pagina e riprovare.");
		                } else {
							var imgW = $("img_warning_" + id);
							var img = $("img_status_" + id);

							var w = imgW.readAttribute("warning");
							if (w == "on") {
								img.writeAttribute("src", "/images/warning.gif");
								imgW.writeAttribute("src", "/images/to_warning_off.gif");
								imgW.writeAttribute("warning", "off");
							} else {
								img.writeAttribute("src", "/images/alert.gif");
								imgW.writeAttribute("src", "/images/to_warning.gif");
								imgW.writeAttribute("warning", "on");
							}
					    }

					   	// Nasconde il loading:
		               	$("nota_loading_" + id).hide();
		  		  }
	});
}
