document.observe("dom:loaded", function() {
	$A($$("#lista_mail input.input_nascosto[ref=pw]")).each(
		function (item) {
			item.readOnly = true;
			item.observe("mouseover", function (event) {
				if ($F("associaP") == "A") {
					var element = event.element();
					element.addClassName("input_attivo");
					element.readOnly = false;
				}
			});

			item.observe("mouseout", function (event) {
				var element = event.element();
				element.removeClassName("input_attivo");
				element.readOnly = true;
			});

			item.observe("focus", function (event) {
				if ($F("associaP") == "A") {
					var element = event.element();
					element.addClassName("input_attivo_on");
					element.readOnly = false;
				}
			});

			item.observe("blur", function (event) {
				var element = event.element();
				element.removeClassName("input_attivo_on");
				element.readOnly = true;

				var mods = element.readAttribute("mods");
				var defvalue = element.readAttribute("defvalue")

				if (parseInt(mods) == 1) {
					element.writeAttribute("mods", 0)
					element.value = defvalue;
				}

				// Aggiorna la password sul server:
				salvaPw(element);
			});
		}
	);
});

function salvaPw(inputElement) {
	var mail_id = inputElement.readAttribute("mail_id");
	var defValue = inputElement.readAttribute("defvalue");
	var pw = inputElement.getValue();

	// Url e corpo del POST:
	var url = "/mail/ajax-save-mail-pw";
	var postQueryString = "mail_id=" + parseInt(mail_id) + "&pw=" + encodeURIComponent(pw);

	if (pw != defValue) {
	 	$("div_loading").show();

		// Richiesta AJAX:
		new Ajax.Request(url, {
				method: 'post',
			    postBody: postQueryString,
			    onFailure: function() {
			    	// Qualcosa è andato storto, quindi ripristina i valori precedenti:
	                var defvalue = inputElement.readAttribute("defvalue")
					inputElement.writeAttribute("mods", 0)
					inputElement.setValue(defvalue);

					// Mostra il msg di errore:
	                alert("Il salvataggio non e' riuscito... Si prega di ricaricare la pagina e riprovare.");
			    },
			    onSuccess: function(transport) {
					inputElement.writeAttribute("mods", 0);
	               	inputElement.writeAttribute("defvalue", inputElement.getValue());
	           },
	           onComplete: function() {
	        	   // Nasconde il div del caricamento:
	        	   $("div_loading").hide();
	           }
	    });
	}
}

function scaricaFoglioAttivazione(id) {
	var form = $("formListaMail");
	var mail_domains_id = $("mail_domains_id");
	mail_domains_id.setValue(id);

	form.submit();
}
