function setCookie(name,value,days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        var expires = "; expires="+date.toGMTString();
    }
    else var expires = "";
    document.cookie = name+"="+value+expires+"; path=/";
}

function getCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function checkShowPlugin() {
	var elems = $A($$(".plugin_column"));
	var cookieVal = 0;
	var showPluginCheckbox = $("show_plugin");

	if (showPluginCheckbox.checked) {
		elems.each(function(item) {
			item.removeClassName("hide");
		});
		cookieVal = 1;
	} else {
		elems.each(function(item) {
			item.addClassName("hide");
		});
	}

	setCookie(COOKIE_VIEW_PLUGIN, cookieVal, 365);
}


// Nome del cookie:
var COOKIE_VIEW_PLUGIN = "__view_plugin";

document.observe("dom:loaded", function() {
	var showPluginCheckbox = $("show_plugin");
	var __ca = getCookie(COOKIE_VIEW_PLUGIN);
	if (__ca == 1) {
		showPluginCheckbox.checked = true;
	}

	Element.observe(showPluginCheckbox, "click", checkShowPlugin);

	checkShowPlugin();
});
