<?php

class Neikos_Acl extends Zend_Acl {
	public function __construct()
	{
		$this->_initRoles();
        $this->_initResources();
        $this->_initPermission();
	}

	private function _initRoles()
    {
		$this->addRole(new Zend_Acl_Role("admin"));
    }

    private function _initResources()
    {
    	$this->add(new Zend_Acl_Resource("clients"));
    	$this->add(new Zend_Acl_Resource("database"));
    	$this->add(new Zend_Acl_Resource("dns"));
    	$this->add(new Zend_Acl_Resource("domains"));
    	$this->add(new Zend_Acl_Resource("error"));
    	$this->add(new Zend_Acl_Resource("ftp"));
    	$this->add(new Zend_Acl_Resource("index"));
    	$this->add(new Zend_Acl_Resource("mail"));
    	$this->add(new Zend_Acl_Resource("mail-domains"));
    	$this->add(new Zend_Acl_Resource("servers"));
    	$this->add(new Zend_Acl_Resource("software"));
    	$this->add(new Zend_Acl_Resource("support"));
    	$this->add(new Zend_Acl_Resource("updates"));
    	$this->add(new Zend_Acl_Resource("users"));
    	$this->add(new Zend_Acl_Resource("utility"));
    }

    private function _initPermission() {
    	$this->allow("admin", null, null, new Neikos_Acl_Assert_Interno());
    	$this->allow("admin", "index");
    	$this->allow("admin", "utility");
    	$this->allow("admin", "error");
    }
}

