<?php

class Neikos_Acl_Assert_Interno implements Zend_Acl_Assert_Interface {
	public function assert(Zend_Acl $acl,
                           Zend_Acl_Role_Interface $role = null,
                           Zend_Acl_Resource_Interface $resource = null,
                           $privilege = null)
    {
    	// Ip della connessione corrente:
    	$ip = Neikos_Utility::getUserIp();

    	// Prende i dati degli ip abilitati a tutte le azioni:
    	$cleanIp = Zend_Registry::get("clean_ip");

    	if (is_array($cleanIp)) {
    		foreach ($cleanIp as $cIp) {
    			// Espande gli asterischi:
    			$cIp = str_replace("*", "§", $cIp);
    			$cIp = preg_quote($cIp);
    			$cIp = str_replace("§", "[0-9]+", $cIp);
    			$cIp = "/^" . $cIp . "$/";

    			// Verifica la corrispondenza:
    			if (preg_match($cIp, $ip)) {
    				return true;
    			}
    		}
    	}

    	return false;
    }
}

