<?php

/**
 * @category   Neikos
 * @package    Neikos_Controller
 * @copyright  Copyright (c) 2008 Neikos s.n.c. (http://www.neikos.it)
 */
abstract class Neikos_Controller_Action extends Zend_Controller_Action
{
    const POST_LOGIN_SESSION_NAME = 'postLoginSession';

    protected function _saveCurrentPageForPostLoginRedirect() {
        $request = $this->_request;

        // Salva l'url di provenienza prima di spedire sulla
        // pagina di login. Non salva niente, se è presente un POST:
        if (!$request->isPost()) {
            $sess = new Zend_Session_Namespace(self::POST_LOGIN_SESSION_NAME);
            if ($sess->isLocked()) {
                $sess->unLock();
            }

            // Url completa della pagina corrente:
            $sess->url = $request->getScheme() . "://" .
                         $request->getHttpHost() .
                         $request->getRequestUri();
            $sess->lock();
        }
    }

    protected function _getPostLoginRedirectUrl() {
        $sess = new Zend_Session_Namespace(self::POST_LOGIN_SESSION_NAME);
        if ($sess->isLocked()) {
            $sess->unLock();
        }
        $url = $sess->url;

        $sess->url = null;
        $sess->lock();

        return $url;
    }
}
