<?php

/**
 * @category   Neikos
 * @package    Neikos_Controller
 * @copyright  Copyright (c) 2008 Neikos s.n.c. (http://www.neikos.it)
 */
abstract class Neikos_Controller_AdminAction extends Neikos_Controller_Action
{
	// Conserva i dati della sessione di autenticazione:
	protected $_auth_session = false;

	// Access control list:
	protected $_acl;

	/**
	 * Costruttore della classe.
	 *
	 * @param Zend_Controller_Request_Abstract $request
	 * @param Zend_Controller_Response_Abstract $response
	 * @param array $invokeArgs
	 */
	public function __construct(Zend_Controller_Request_Abstract $request, Zend_Controller_Response_Abstract $response, array $invokeArgs = array())
    {
    	// Esegue prima il costruttore della classe base:
    	parent::__construct($request, $response, $invokeArgs);

    	// Legge la sessione di autenticazione:
    	$this->_loadSession();

    	// Legge l'ACL:
    	$this->_loadAcl();

    	// Passa l'ACL alla view:
    	$this->view->acl = $this->_acl;

    	// Controlla che l'utente sia autenticato:
    	if (!$this->_isAuth()) {
    	    // Salve in sessione l'url corrente:
    	    $this->_saveCurrentPageForPostLoginRedirect();

    	    // Redirige sul form di login:
    	    $this->_redirectToLogin();
    	} else {
    	    // Controlla se si ha diritto di accedere alla pagina corrente:
    	    if (!$this->_hasAccess()) {
    	        // Redirige sulla index:
    	        $this->_redirectToLogin();
    	    }
    	}
    }


    protected function _redirectToLogin() {
        // In caso di richiesta AJAX:
        if ($this->_request->isXmlHttpRequest()) {
            // Disattiva la risposta:
            $this->_helper->layout()->disableLayout();
            $this->_helper->viewRenderer->setNoRender();

            echo "FORCE_PAGE_RELOAD";
        } else {
            $this->_helper->getHelper("redirector")->goto("login", "users");
        }
    }


    protected function _loadAcl() {
    	$this->_acl = new Neikos_Acl();
    }


    /**
     * Controlla che si abbiano i privilegi di accesso.
     */
	protected function _hasAccess() {
		$controller = $this->getRequest()->getControllerName();
    	$action = $this->getRequest()->getActionName();

       	return $this->_acl->isAllowed("admin", $controller, $action);
	}

    /**
     * Controlla se un utente è autenticato.
     *
     * @return bool - true: autenticato, false: non autenticato.
     */
    protected function _isAuth() {
    	if ($this->_auth_session->autenticato) {
			return true;
		}

    	return false;
    }

    /**
     * Legge la sessione di autenticazione.
     */
    protected function _loadSession() {
    	// Legge la sessione di autenticazione:
    	$this->_auth_session = new Zend_Session_Namespace('auth');
		$this->_auth_session->setExpirationSeconds(3600);
    }

    /**
     * Rende accessibile i dati dell'autenticazione in ogni azione
     * in cui si è passata la validazione richiesta del login.
     */
    protected function _getAuthInfo() {
    	return $this->_auth_session->user_info;
    }
}
