<?php

require_once 'Zend/Filter/Interface.php';

class Neikos_Filter_Date implements Zend_Filter_Interface
{
	const FORMAT_DATE_LONG = 'date_long';
	const FORMAT_DATE_SHORT = 'date_short';
	const FORMAT_DATE_SQL = 'date_sql';
	const FORMAT_DATETIME = 'datetime';
	const FORMAT_DATETIME_SQL = 'datetime_sql';
	const FORMAT_TIME_LONG = 'time_long';
	const FORMAT_TIME_MILITARY = 'time_military';
	const FORMAT_TIME_PRECISION = 'time_precision';
	const FORMAT_TIME_SHORT = 'time_short';
	const FORMAT_TIME_SQL = 'time_sql';

	protected $_options = array(
		'format'   => null,
	    'nullable' => false
	);

    public function __construct($options = null) {
		if ($options instanceof Zend_Config) $options = $options->toArray();
		if (!is_null($options)) $this->setOptions($options);
    }

	public function getOptions() {
		return $this->_options;
	}

	public function setOptions(array $options = null) {
		$this->_options = $options + $this->_options;
		return $this;
	}

	public function filter($dateString) {
	    $time = strtotime($dateString);
	    if ($time === false && $this->_options['nullable']) {
	        return null;
	    }

		switch ($this->_options['format']) {
    		case self::FORMAT_DATE_LONG:
    		    $filteredValue = date('l, F j, Y', $time);
    		    break;
			case self::FORMAT_DATE_SHORT:
			    $filteredValue = date('m/d/Y', $time);
			    break;
			case self::FORMAT_DATE_SQL:
			    $filteredValue = date('Y-m-d', $time);
			    break;
			case self::FORMAT_DATETIME:
			    $filteredValue = date('l, F j, Y g:i A', $time);
			    break;
			case self::FORMAT_DATETIME_SQL:
			    $filteredValue = date('Y-m-d H:i:s', $time);
			    break;
			case self::FORMAT_TIME_LONG:
			    $filteredValue = date('h:i:s A', $time);
			    break;
			case self::FORMAT_TIME_MILITARY:
			    $filteredValue = date('H:i:s', $time);
			    break;
			case self::FORMAT_TIME_PRECISION:
			    $date = new DateTime();
			    $date->setTimestamp($time);
			    $filteredValue = $date->format('H:i:s.u');
			    break;
			case self::FORMAT_TIME_SHORT:
			    $filteredValue = date('h:i A', $time);
			    break;
			case self::FORMAT_TIME_SQL:
			    $filteredValue = date('H:i:s', $time);
			    break;
			default:
			    $filteredValue = date($this->_options['format'], $time);
			    break;
		}

		return $filteredValue;
	}
}