<?php

/** Zend_Form_Element_Select */
require_once 'Zend/Form/Element/Select.php';

/**
 * @category   Neikos
 * @package    Neikos_Form
 */
class Neikos_Form_Element_ComboSelect extends Zend_Form_Element_Select {
	// Elemento che subisce l'influenza del cambio di valore della select corrente:
	protected $_elementsRef = array();

	// Azione da intraprendere in caso di aggiornamento del valore del select corrente:
	protected $_callback = null;

	/**
	 * Setta la funzione di callback su un altro elemento.
	 *
	 * @param string|array $callback
	 * @param Zend_Form_Element $element
	 *
	 * @return Neikos_Form_Element_ComboSelect
	 */
	public function setCallback($options) {
		$callback = $options["callback"];
		$elements = $options["elements"];

        if (!is_string($callback) && !is_array($callback)) {
            require_once 'Zend/Form/Exception.php';
            throw new Zend_Form_Exception('Invalid callback provided to ComboSelect');
        }

        if (is_array($callback)) {
            if (2 !== count($callback)) {
                require_once 'Zend/Form/Exception.php';
                throw new Zend_Form_Exception('Invalid method callback provided to ComboSelect');
            }
        }

        if (!is_array($elements)) {
        	$elements = array($elements);
        }

        if (count($elements)>0) {
        	foreach ($elements as $element) {
        		if ($element instanceOf Zend_Form_Element) {
					$this->_elementsRef[] = $element;
				} else {
					require_once 'Zend/Form/Exception.php';
		        	throw new Zend_Form_Exception('Invalid Element Reference');
				}
        	}
        }

        $this->_callback = $callback;
        return $this;
    }

	/**
     * Set element value
     *
     * @param  mixed $value
     * @return Zend_Form_Element
     */
    public function setValue($value) {
        $this->_value = $value;

		// Esegue la callback:
		if (count($this->_elementsRef) > 0 && $this->_callback !== null) {
			foreach ($this->_elementsRef as $element) {
				$response = call_user_func($this->_callback, $element, $this->_value);
			}
		}

        return $this;
    }
}
