<?php

/** Zend_Form_Element_Select */
require_once 'Zend/Form/Element/Xhtml.php';

/**
 * @category   Neikos
 * @package    Neikos_Form
 */
class Neikos_Form_Element_MultiIpAddresses extends Zend_Form_Element_Xhtml {
   /**
    * View da utilizzare per il rendering
    * @var string
    */
   public $helper = 'formMultiIpAddresses';


   /**
     * Set element value
     *
     * @param  mixed $value
     * @return Zend_Form_Element
     */
    public function setValue($value)
    {
        if (!is_array($value)) {
            $value = array($value);
        }

        $this->_value = $this->_cleanIpList($value);

        return $this;
    }


    /**
     * Elimina eventuali valori vuoti
     *
     * @param array $list
     * @return array
     */
    protected function _cleanIpList($list) {
        $newList = array();

        if (!is_array($list)) $list = array($list);

        if (count($list)>0) {
            foreach ($list as $ip) {
                if (!empty($ip) && ip2long($ip) !== false) {
                    $newList[] = $ip;
                }
            }
        }

        return $newList;
    }
}