<?php
/**
 * Classe per la gestione del Log su file.
 */

class Neikos_Log {
	const EMERG   = 0;  // Emergency: system is unusable
	const ALERT   = 1;  // Alert: action must be taken immediately
	const CRIT    = 2;  // Critical: critical conditions
	const ERR     = 3;  // Error: error conditions
	const WARN    = 4;  // Warning: warning conditions
	const NOTICE  = 5;  // Notice: normal but significant condition
	const INFO    = 6;  // Informational: informational messages
	const DEBUG   = 7;  // Debug information.

	private static $_log = null;

	public static function getInstance()
    {
        if (self::$_log === null) {
            self::init();
        }

        return self::$_log;
    }

	public static function setInstance(Neikos_Log $log)
    {
        self::$_log = $log;
    }

 	private static function init()
    {
        self::setInstance(new self());
    }

    /**
     * Istanza del logger:
     */
    private $_logger;

	/**
	 * Costruttore della classe:
	 */
	private function __construct() {
		// Prende dal registro dell'applicazione i dati
		// relativi alla path del file di log:
		$bootstrap = Zend_Controller_Front::getInstance()->getParam("bootstrap");
		$dataLog = $bootstrap->getOption("log");

		$file = $dataLog["path"] . $dataLog["filename"];

		// Crea la connessione al file:
		$stream = @fopen($file, "a+");
		if (!$stream) {
	    	throw new Exception('Impossibile scrivere sul file di log!');
		}

		$format = '%message% - (%priorityName%)' . PHP_EOL;
		$formatter = new Zend_Log_Formatter_Simple($format);

		$writer = new Zend_Log_Writer_Stream($stream);
		$writer->setFormatter($formatter);

		$this->_logger = new Zend_Log($writer);
	}

	/**
	 * Metodo per scrivere sul file di log.
	 *
	 * @param string|array $testo
	 * @param int $priority
	 */
	public static function Write($testo, $priority = Neikos_Log::INFO) {
		// Controlla la priorità passata:
		if ($priority > 7 || $priority < 0) {
			// throw new Exception('Errore nel sistema di log. Priorità assegnata errata.');
			$priority = Log::DEBUG;
		}

		// Trasforma il testo in array se non lo è già:
		if (!is_array($testo)) {
			$testo = array($testo);
		}

		// Ottiene l'istanza del logger:
		$log = self::getInstance();

		// Ottiene il nome dell'utente corrente:
		$authSession = new Zend_Session_Namespace('auth');
		$nome_utente = $authSession->user_info["user"];

		// Imposta l'inizio della riga:
		$eventMsg = date("Y-m-d H:i:s") . " - " . $_SERVER["REMOTE_ADDR"] .  " - " . strtoupper($nome_utente) . " - ";

		foreach ($testo as $riga) {
			// Scrive il messaggio sul log:
			$log->_logger->info($eventMsg . $riga);
		}
	}
}

?>
