<?php

/**
 * Classe per la gestione dei messaggi di successo nel sistema.
 */
class Neikos_Systemmessage {
	const MSG_ERRORE = 0;
	const MSG_OK = 1;

	private $_smSession;
	private static $_delimiter = "<br />\n";
	private static $_sm = null;

	public static function getInstance()
    {
        if (self::$_sm === null) {
            self::init();
        }

        return self::$_sm;
    }

	public static function setInstance(Neikos_Systemmessage $sm)
    {
        self::$_sm = $sm;
    }

 	private static function init()
    {
        self::setInstance(new Neikos_Systemmessage());
    }

	private function __construct() {
		$this->_smSession = new Zend_Session_Namespace('smSession');
		$this->_smSession->setExpirationSeconds(3600);
		if ($this->_smSession->isLocked()) {
			$this->_smSession->unLock();
		}

		if (!is_array($this->_smSession->_messageStack)) {
			$this->_smSession->_messageStack = array(
							self::MSG_OK 		=> array(),
							self::MSG_ERRORE 	=> array()
			);
		}
	}

	public function __destruct() {
		$this->_smSession->lock();
	}

	public static function push($msg, $tipo = self::MSG_OK) {
		$sm = self::getInstance();
		$mss = $sm->_smSession->_messageStack;

		array_push($mss[$tipo], $msg);

		$sm->_smSession->_messageStack = $mss;
	}

	public static function pop($tipo = self::MSG_OK) {
		$sm = self::getInstance();

		if (count($sm->_smSession->_messageStack[$tipo]) > 0) {
			return @array_pop($sm->_smSession->_messageStack[$tipo]);
		}
		return null;
	}

	public static function getAll($tipo = self::MSG_OK) {
		$ret = "";
		$msg = null;

		$cont = 0; // variabile di sicurezza.
		do {
			$msg = self::pop($tipo);

			if ($msg != null) {
				$ret .= "<li>" . $msg . "</li>";
			}

			$cont++;
			if ($cont>1000) break; // permette al massimo 1000 cicli.
		} while (null !== $msg);

		return $ret;
	}
}

?>