<?php

class Neikos_Utility {
	static function formatDimByte($dimensione, $formatta = true, $dec = -1) {
		if ($dec == -1) {
			$decimali = 0;
		}

		if ($formatta) {
			if ($dimensione >= 1073741824) {
				if ($dec == -1) $decimali = 2;
				return number_format($dimensione/1073741824, (int)$decimali, '.', ' ') . " GB";
			} else if ($dimensione >= 1048576) {
				if ($dec == -1) $decimali = 2;
				return number_format($dimensione/1048576, (int)$decimali, '.', ' ') . " MB";
			} else if ($dimensione >= 1024) {
				return number_format($dimensione/1024, (int)$decimali, '.', ' ') . " kB";
			} else {
				return (int)$dimensione . " B";
			}
		} else {
			return (int)$dimensione;
		}
	}


	static function escape($text) {
		$tr = array('"' => "&quot;");
		return strtr(stripslashes($text), $tr);
	}

	static function getUserIp() {
	    $ip = null;

	    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
	        $ip = $_SERVER['HTTP_CLIENT_IP'];
	    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	    } else {
	        $ip = $_SERVER['REMOTE_ADDR'];
	    }

	    return $ip;
	}
}
