<?php

require_once("Zend/Validate/Abstract.php");

class Neikos_Validate_PasswordCheck extends Zend_Validate_Abstract
{
	const NO_CONTEXT     = "cvpNoContext";
    const NO_CONTEXT_KEY = "cvpNoContextKey";
    const NOT_IDENTICAL  = "cvpNotIdentical";

    protected $_contextKey = 'repassword';

    protected $_messageTemplates = array(
    	self::NO_CONTEXT     => 'Nessun contesto fornito al validatore',
        self::NO_CONTEXT_KEY => 'Nessun campo di confronto trovato nel contesto',
        self::NOT_IDENTICAL  => 'Le password non coincidono',
    );

    public function __construct($options = null)
    {
    	if (is_string($options)) {
        	$this->_contextKey = $options;
        } elseif (is_array($options) && isset($options['contextKey'])) {
            $this->_contextKey = $options['contextKey'];
        }
    }

    public function isValid($value, $context = null)
    {
    	if (!is_array($context)) {
        	$this->_error(self::NO_CONTEXT);
            return false;
        }

        if (!isset($context[$this->_contextKey])) {
            $this->_error(self::NO_CONTEXT_KEY);
        	return false;
        }

        $compare = $context[$this->_contextKey];
        if ($value != $compare) {
        	$this->_error(self::NOT_IDENTICAL);
            return false;
        }

        return true;
   	}
}

?>