<?php


/**
 * @see Zend_Validate_Abstract
 */
require_once 'Zend/Validate/Abstract.php';


class Neikos_Validate_ValueNotEqual extends Zend_Validate_Abstract {
  const KEY_NOT_FOUND  = 'keyNotFound';
  const KEY_EQUAL   = 'keyIsEmpty';

  protected $_messageTemplates = array(
    self::KEY_NOT_FOUND  => 'Il campo di controllo non esiste tra quelli del form',
    self::KEY_EQUAL   	 => 'I due campi forniti coincidono',
  );

  protected $_contextKey;

  public function __construct($contextKey) {
  	$this->setContextKey($contextKey);
  }

  public function isValid($value, $context = null) {
    $contextKey = $this->getContextKey();

    // If context key is an array, doValid for each context key
    if (is_array($contextKey)) {
    	foreach ($contextKey as $ck) {
        	$this->setContextKey($ck);
        	if(!$this->doValid($value, $context)) {
          		return false;
        	}
      	}
    } else {
      	if(!$this->doValid($value, $context)) {
        	return false;
      	}
    }

    return true;
  }

  public function doValid($value, $context = null) {
    $contextKey = $this->getContextKey();
    $value      = (string) $value;
    $this->_setValue($value);

    if ((null === $context) || !is_array($context) || !array_key_exists($contextKey, $context)) {
      $this->_error(self::KEY_NOT_FOUND);
      return false;
    }

    if (is_array($context[$contextKey])) {
      $parentField = $context[$contextKey][0];
    } else {
      $parentField = $context[$contextKey];
    }

    if ($value == $parentField) {
    	$this->_error(self::KEY_EQUAL);
        return false;
    }

    return true;
  }

  /**
   * @return string
   */
  protected function getContextKey() {
    return $this->_contextKey;
  }

  /**
   * @param string $contextKey
   */
  protected function setContextKey($contextKey) {
    $this->_contextKey = $contextKey;
  }
}

?>