<?php

require_once 'Zend/View/Helper/FormElement.php';

/**
 * Helper per il multi ip address
 *
 * @category   Neikos
 * @package    Neikos_View
 * @subpackage Helper
 */
class Neikos_View_Helper_FormDatePicker extends Zend_View_Helper_FormElement
{
    public function formDatePicker($name, $value = null, $attribs = null)
    {
        $info = $this->_getInfo($name, $value, $attribs);
        extract($info); // name, value, attribs, options, listsep, disable

        // build the element
        $disabled = '';
        if ($disable) {
            // disabled
            $disabledTag = ' disabled="disabled"';
        }

        // Js e css:
        $noJs       = (bool)$attribs['no_js'];
        $noCss      = (bool)$attribs['no_css'];
        $jsPath     = $attribs['js_path'];
        $cssPath    = $attribs['css_path'];

        // Appende gli script e i css necessari:
        if (!$noCss) {
            $this->view->headLink(array("rel" => "stylesheet", "href" => $cssPath . "calendarview.css", "type" => "text/css", "media" => "screen"));
        }

        if (!$noJs) {
            $this->view->headScript()->appendFile($jsPath . "calendarview.js", "text/javascript");
        }

        $this->view->headScript()->appendScript(
            "
                document.observe('dom:loaded', function() {
       	           Calendar.setup({
                      dateField      : '" . $this->view->escape($id) . "',
                      triggerElement : '" . $this->view->escape($id) . "_button'
                   });
                });
            ",
            "text/javascript"
        );

        $xhtml = '<input type="text"'
                . ' name="' . $this->view->escape($name) . '"'
                . ' id="' . $this->view->escape($id) . '"'
                . ' value="' . $this->view->escape($value) . '"'
                . $disabledTag
                . $this->_htmlAttribs($attribs)
                . ' readonly="readonly"'
                . $this->getClosingBracket();

        if (!$disabled) {
            $xhtml .= '<button type="button" id="' . $this->view->escape($id) . '_button">scegli</button>';
        }

        return $xhtml;
    }
}