<?php

require_once 'Zend/View/Helper/FormElement.php';

/**
 * Helper per il multi ip address
 *
 * @category   Neikos
 * @package    Neikos_View
 * @subpackage Helper
 */
class Neikos_View_Helper_FormMultiIpAddresses extends Zend_View_Helper_FormElement
{
    public function formMultiIpAddresses($name, $value = null, $attribs = null)
    {
        $info = $this->_getInfo($name, $value, $attribs);
        extract($info); // name, value, attribs, options, listsep, disable

        // build the element
        $disabled = '';
        if ($disable) {
            // disabled
            $disabled = ' disabled="disabled"';
        }

        // Carica nell'head lo script che server per il funzionamento dell'elemento:
        $this->view->headScript()->appendScript(
            "
            function _addNewToMultiIpAddressesContainer(container, id) {
            	var container = document.getElementById(container);
            	var newIp = document.createElement('input');
            	newIp.setAttribute('type', 'text');
            	newIp.setAttribute('name', id);
            	newIp.setAttribute('value', '');

            	container.appendChild(newIp);
            }
            ",
            "text/javascript"
        );

        // Mette tutto in un div:
        $xhtml = "<div id='" . $this->view->escape($id) . "_container'>";

        // $list = explode(";", $value);

        if (count($value) > 0) {
            foreach ($value as $ip) {
                $xhtml .= '<input type="text"'
                        . ' name="' . $this->view->escape($name) . '[]"'
                        . ' value="' . $this->view->escape($ip) . '"'
                        . $disabled
                        . $this->_htmlAttribs($attribs)
                        . $this->getClosingBracket();
			}
        }
        $xhtml .= "</div>";

        $xhtml .= "<a id=\"listaIp\" href=\"javascript:_addNewToMultiIpAddressesContainer('" . $this->view->escape($id) . "_container', '" . $this->view->escape($name) . "[]')\">Aggiungi indirizzo IP</a><br />";
        if (!empty($attribs['note'])) {
            $xhtml .= "<span class='info'>" . $attribs['note'] . "</span>";
        }

        return $xhtml;
    }
}