#!/usr/bin/ruby

require 'rubygems'
require 'net/http'
require 'net/https'
require 'uri'
require 'nokogiri'
require 'fileutils'

url_base = 'https://mycloud.seeweb.it'

path_login = 'index.php'
path_get_data = 'usestat.php'
path_get_image = 'usegraph.php'

# 13 	adriaeco - petrini	OK
# 33 	adv.ottopagine.net	OK
# 16 	beneventofree.it	NO (Rimosso)
# 10 	cloud01.neikos.it	OK
# 42 	cloud02.neikos.it	OK
# 44 	cloud03.neikos.it	OK
# 36 	diocesidibenevento.it	OK
# 35 	idealisrl.it		OK
# 24 	illiquidx.com		OK
# 21 	lab81.com		OK
# 22 	lineamarche.it		OK
# 31 	omadadesign.com		OK
# 40 	premiostrega.it		OK
# 18 	promocarmotori.it	NO
# 44 	recetas-italianas.com	OK
# 41 	santa-rosa.it		OK
# 30 	santonishoes.com	OK
# 20 	sidel.neikos.it		OK
# 26 	sudest.it		OK
# 17 	telecomputers.it	OK
# 11 	tvsette.net		OK
# 25 	valsoia.it		OK
# 23 	wp.neikos.it		OK

clouds = [
          {'username' => 'adriaeco.eu', 'password' => 'rrd7016', 'login' => 'Entra' }, 
          {'username' => 'adv.ottopagine.net', 'password' => 'thaiNg0o', 'login' => 'Entra' }, 
          {'username' => 'beneventofree.it', 'password' => 'enb8346', 'login' => 'Entra' }, 
          {'username' => 'cloud01.neikos.it', 'password' => 'jeTh5ya6', 'login' => 'Entra' }, 
          {'username' => 'cloud02.neikos.it', 'password' => 'AengoiJ4', 'login' => 'Entra'},
          {'username' => 'cloud03.neikos.it', 'password' => 'eeH9ji9E', 'login' => 'Entra'},
          {'username' => 'diocesidibenevento.it', 'password' => 'ieGh0eix', 'login' => 'Entra'},
          {'username' => 'idealisrl.it', 'password' => 'iZoo5ohy', 'login' => 'Entra'},
          {'username' => 'illiquidx.com', 'password' => 'MaeS0efu', 'login' => 'Entra' },
          {'username' => 'lab81.com', 'password' => 'Veet4Cho', 'login' => 'Entra' },
          {'username' => 'lineamarche.it', 'password' => 'Hequoh5A', 'login' => 'Entra' }, 
          {'username' => 'omadadesign.com', 'password' => 'Hul4eigh', 'login' => 'Entra' }, 
          # {'username' => 'ottopagine.net', 'password' => 'outh5Yai', 'login' => 'Entra' }, 
          {'username' => 'premiostrega.it', 'password' => 'nuFequ6G', 'login' => 'Entra'},
          # {'username' => 'promocarmotori.it', 'password' => 'aithae9W', 'login' => 'Entra' }, 
          {'username' => 'recetas-italianas.com', 'password' => 'MeWee3ei', 'login' => 'Entra'},
          {'username' => 'santa-rosa.it', 'password' => 'aeH7uu2d', 'login' => 'Entra'},
          {'username' => 'santonishoes.com', 'password' => 'Uu2tiunu', 'login' => 'Entra' }, 
          {'username' => 'sidel.neikos.it', 'password' => 'eeg0Oohe', 'login' => 'Entra' }, 
          {'username' => 'sudest.it', 'password' => 'Ohjab6Ch', 'login' => 'Entra' }, 
          {'username' => 'telecomputers.it', 'password' => 'lee2651', 'login' => 'Entra' }, 
          {'username' => 'tvsette.net', 'password' => 'aZ6iedeb', 'login' => 'Entra' }, 
          {'username' => 'valsoia.it', 'password' => 'Iotu2lie', 'login' => 'Entra' },  
          # {'username' => 'vinit.net', 'password' => 'auf4koiM', 'login' => 'Entra'},
          {'username' => 'wp.neikos.it', 'password' => 'Ieph9aeg', 'login' => 'Entra' }, 
         ]

images = { 
  :gw => 'resourcename=wuindex&type=WUI',
  :ge => 'resourcename=muindex&type=MUI',
  :gd => 'resourcename=duindex&type=DUI',
  :wb => 'resourcename=net&type=WUI',
  :wi => 'resourcename=io&type=WUI',
  :wd => 'resourcename=disk&type=WUI',
  :wm => 'resourcename=memory&type=WUI',
  :wc => 'resourcename=cpucycle&type=WUI',
  :ep => 'resourcename=pop3&type=MUI',
  :ei => 'resourcename=imap&type=MUI',
  :es => 'resourcename=smtp&type=MUI',
  :ed => 'resourcename=maildisk&type=MUI',
  :di => 'resourcename=io&type=DUI',
  :dd => 'resourcename=disk&type=DUI',
  :dm => 'resourcename=memory&type=DUI',
  :dc => 'resourcename=cpucycle&type=DUI',
}


dest_dir = './sites'

global_status = true
web_status = true
email_status = false
db_status = true

@placeholder = dest_dir + '/images/placeholder.png'

def connect url, method=:get, params=nil, userAgent=nil, timeout=30
  url = URI.parse(url)
  sock = Net::HTTP.new(url.host, url.port)
  sock.use_ssl = true
  sock.open_timeout = timeout
  sock.read_timeout = timeout

  req = Net::HTTP::Get.new(url.request_uri)
  req['Cookie'] = @cookies
  if userAgent.nil?
    userAgent = 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.89 Safari/537.1'
  end
  req['User-Agent'] = userAgent


  if method == :post
    req = Net::HTTP::Post.new(url.path)
    req.set_form_data(params)
  end

  res = sock.start{ |http| 
    http.open_timeout = timeout
    http.read_timeout = timeout
    http.request(req) 
  }

  if res.code.to_i != 200
    raise 'http error code: ' + res.code
  end

  all_cookies = res.get_fields('set-cookie')
  unless all_cookies.nil?
    cookies_array = Array.new
    all_cookies.each { | cookie |
      cookies_array.push(cookie.split('; ')[0])
    }
    @cookies = cookies_array.join('; ')
  end
  res.body
end

def downloadImage url
  connect(url, nil, nil, nil, 10)
end

def createNodeSetXml doc, params
  global = (params[:global].nil?) ? [0,0] : params[:global]
  web = (params[:web].nil?) ? [0,0] : params[:web]
  email = (params[:email].nil?) ? [0,0] : params[:email]
  database = (params[:database].nil?) ? [0,0] : params[:database]

  xml = Nokogiri::XML::NodeSet.new(doc)

  global_xml = Nokogiri::XML::Node.new('global', doc)
  global_xml.set_attribute('current', global[0].to_s)
  global_xml.set_attribute('default', global[1].to_s)
  global_xml.set_attribute('alert', 'alert') if global[0].to_i > global[1].to_i
  xml << global_xml

  web_xml = Nokogiri::XML::Node.new('web', doc)
  web_xml.set_attribute('current', web[0].to_s)
  web_xml.set_attribute('default', web[1].to_s)
  web_xml.set_attribute('alert', 'alert') if web[0].to_i > web[1].to_i
  xml << web_xml

  email_xml = Nokogiri::XML::Node.new('email', doc)
  email_xml.set_attribute('current', email[0].to_s)
  email_xml.set_attribute('default', email[1].to_s)
  email_xml.set_attribute('alert', 'alert') if email[0].to_i > email[1].to_i
  xml << email_xml

  database_xml = Nokogiri::XML::Node.new('database', doc)
  database_xml.set_attribute('current', database[0].to_s)
  database_xml.set_attribute('default', database[1].to_s)
  database_xml.set_attribute('alert', 'alert') if database[0].to_i > database[1].to_i
  xml << database_xml

  return xml
end

def createXml file, params
  doc = nil

  doc = Nokogiri::XML::Document.new()
  doc.encoding='UTF-8'
  doc << '<root></root>'
  doc = Nokogiri::XML(open(file)) { |x| x.noblanks } if File.exist?(file)

  current = doc.at_css('current')
  current.remove unless current.nil?

  current = Nokogiri::XML::Node.new('current', doc)
  current << createNodeSetXml(doc, params)
  doc.root << current

  history = doc.at_css('history')
  history = Nokogiri::XML::Node.new('history', doc) if history.nil?
  data = Nokogiri::XML::Node.new('data', doc)
  data.set_attribute('date', Time.now.to_i.to_s)
  data.set_attribute('datestr', Time.now.to_s)
  data << createNodeSetXml(doc, params)
  history << data
  doc.root << history

  return doc
end

def createMainXml file, hostname, params
  doc = nil

  doc = Nokogiri::XML::Document.new()
  doc.encoding='UTF-8'
  doc << '<root></root>'
  doc = Nokogiri::XML(open(file)) { |x| x.noblanks } if File.exist?(file)

  ch = doc.xpath("//ch[@hostname='#{hostname}']")
  ch.remove unless ch.nil?

  ch = Nokogiri::XML::Node.new('ch', doc)
  ch.set_attribute('hostname', hostname)
  ch.set_attribute('date', Time.now.to_i.to_s)
  ch.set_attribute('datestr', Time.now.to_s)
  ch << createNodeSetXml(doc, params)
  doc.root << ch

  return doc
end

def saveXml doc, file
  File.open(file, 'w+') do |fb|
    #puts builder.to_xml
    fb.write doc.to_xml
  end
end

def copyPlaceholder dest
    FileUtils.cp @placeholder,dest
end

def getImage dest, url
  begin
    File.open(dest, 'w') do |fb|
      fb.write downloadImage url
    end

    copyPlaceholder(dest) unless File.size(dest).to_i > 0
    
  rescue Exception => ex
    copyPlaceholder dest
    #print ' ' + ex.message
    # puts "\t" + ex.backtrace.join("\n\t")
  end
end

clouds.each do |params|
  print params['username']
  begin
    url = url_base + '/' + path_login
    res = connect(url, :post, params)

    url = url_base + '/' + path_get_data
    res = connect(url, :get, nil)
    
    doc = Nokogiri::HTML(res)
    data = doc.xpath('//table/*')[4] 

    raise "HTTP Error" if data.nil?

    # Check Directory
    current_dir = dest_dir + '/' + params['username']
    unless (File.directory?(current_dir))
      Dir.mkdir(current_dir)
    end

    data = data.xpath('.//table/*')
        
    global = data[0].xpath('./td')[1].content.split('/').map{ |x| x.strip}
    web = data[3].xpath('./td')[1].content.split('/').map{ |x| x.strip}
    email = data[5].xpath('./td')[1].content.split('/').map{ |x| x.strip}
    database = data[7].xpath('./td')[1].content.split('/').map{ |x| x.strip}
    #puts " Global:" + global.inspect + (global[0].to_i > global[1].to_i ? '<- ALERT': '')
    #puts " Web:\t" + web.inspect  + (web[0].to_i > web[1].to_i ? '<- ALERT': '')
    #puts " Email:\t" + email.inspect + (email[0].to_i > email[1].to_i ? '<- ALERT': '')
    #puts " DB:\t" + database.inspect + (database[0].to_i > database[1].to_i ? '<- ALERT': '') 
    
    # ADD node to specific XML
    file = current_dir + '/data.xml'
    doc = createXml(file, {:global => global, :web => web, :email => email, :database => database})
    saveXml doc, file

    # ADD node to main XML
    file = dest_dir + '/main.xml'
    doc = createMainXml(file, params['username'], {:global => global, :web => web, :email => email, :database => database})
    saveXml doc, file
    print ' ->'

    # Indice delle SPU utilizzate
    #   WEB: https://mycloud.seeweb.it/usegraph.php?resourcename=wuindex&type=WUI
    #   EMAIL: https://mycloud.seeweb.it/usegraph.php?resourcename=muindex&type=MUI
    #   D ATABASE: https://mycloud.seeweb.it/usegraph.php?resourcename=duindex&type=DUI
    if global_status
      print ' G'

      getImage current_dir + '/global_web.png', url_base + '/' + path_get_image + '?' + images[:gw]
      print '.'      
      getImage current_dir + '/global_email.png', url_base + '/' + path_get_image + '?' + images[:ge]
      print '.'
      getImage current_dir + '/global_database.png', url_base + '/' + path_get_image + '?' + images[:gd]
      print '.'
    end
          
    # Dettagli WEB
    #   Banda: https://mycloud.seeweb.it/usegraph.php?resourcename=net&type=WUI
    #   IO Disco: https://mycloud.seeweb.it/usegraph.php?resourcename=io&type=WUI
    #   Spazio Disco: https://mycloud.seeweb.it/usegraph.php?resourcename=disk&type=WUI
    #   Memoria: https://mycloud.seeweb.it/usegraph.php?resourcename=memory&type=WUI
    #   Utilizzo CPU: https://mycloud.seeweb.it/usegraph.php?resourcename=cpucycles&type=WUI
    if web_status
      print ' W'
      
      getImage current_dir + '/web_banda.png', url_base + '/' + path_get_image + '?' + images[:wb]
      print '.'
      getImage current_dir + '/web_io.png', url_base + '/' + path_get_image + '?' + images[:wi]
      print '.'
      getImage current_dir + '/web_disk.png', url_base + '/' + path_get_image + '?' + images[:wd]
      print '.'
      getImage current_dir + '/web_memory.png', url_base + '/' + path_get_image + '?' + images[:wm]
      print '.'
      getImage current_dir + '/web_cpu.png', url_base + '/' + path_get_image + '?' + images[:wc]
      print '.'
    end
    
    # Dettagli EMAIL
    #   POP3: https://mycloud.seeweb.it/usegraph.php?resourcename=pop3&type=MUI
    #   IMAP: https://mycloud.seeweb.it/usegraph.php?resourcename=imap&type=MUI
    #   SMTP: https://mycloud.seeweb.it/usegraph.php?resourcename=smtp&type=MUI
    #   Utilizzo Disco: https://mycloud.seeweb.it/usegraph.php?resourcename=maildisk&type=MUI
    if email_status
      print ' E'
      getImage current_dir + '/email_pop3.png', url_base + '/' + path_get_image + '?' + images[:ep]
      print '.'
      getImage current_dir + '/email_imap.png', url_base + '/' + path_get_image + '?' + images[:ei]
      print '.'
      getImage current_dir + '/email_smtp.png', url_base + '/' + path_get_image + '?' + images[:es]
      print '.'
      getImage current_dir + '/email_disk.png', url_base + '/' + path_get_image + '?' + images[:ed]
      print '.'
    end
  
    # Dettagli DATABASE
    #   Spazio Disco: https://mycloud.seeweb.it/usegraph.php?resourcename=disk&type=DUI
    #   IO Disco: https://mycloud.seeweb.it/usegraph.php?resourcename=io&type=DUI
    #   Memoria: https://mycloud.seeweb.it/usegraph.php?resourcename=memory&type=DUI
    #   Utilizzo CPU: https://mycloud.seeweb.it/usegraph.php?resourcename=cpucycles&type=DUI
    if db_status
      print ' D'

      getImage current_dir + '/db_io.png', url_base + '/' + path_get_image + '?' + images[:di]
      print '.'
      getImage current_dir + '/db_disk.png', url_base + '/' + path_get_image + '?' + images[:dd]
      print '.'
      getImage current_dir + '/db_memory.png', url_base + '/' + path_get_image + '?' + images[:dm]
      print '.'
      getImage current_dir + '/db_cpu.png', url_base + '/' + path_get_image + '?' + images[:dc]
      print '.'
    end

    print " OK\n"
  
    # Pause for 2 second
    sleep 3
  rescue Exception => ex
    puts " " + ex.message
    # puts "\t" + ex.backtrace.join("\n\t")
  end
end

