#!/usr/bin/ruby

require 'rubygems'
require 'nokogiri'

@dest_dir = './sites'

@html_header =<<EOF
<!DOCTYPE html>
<html>
  <head>
    <title>Cloud Hosting - Main</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="google" content="notranslate">

    <script type="text/javascript" src="js/jquery.js"></script>
    <script type="text/javascript" src="js/jquery.lightbox-0.5.js"></script>
    <link rel="stylesheet" type="text/css" href="css/jquery.lightbox-0.5.css" media="screen" />
    
    <script type="text/javascript">
    $(function() {
        $('.image a').lightBox();
    });
    </script>
    <style type="text/css">
        #gallery {
                background-color: #444;
                padding: 10px;
                width: 520px;
        }
        #gallery ul { list-style: none; }
        #gallery ul li { display: inline; }
        #gallery ul img {
                border: 5px solid #3e3e3e;
                border-width: 5px 5px 20px;
        }
        #gallery ul a:hover img {
                border: 5px solid #fff;
                border-width: 5px 5px 20px;
                color: #fff;
        }
        #gallery ul a:hover { color: #fff; }

        .title {font-size:20px;}
        .child {float: left; border: 1px solid blue; margin: 5px; padding: 5px; min-height: 575px;}
        .child .title {}
        .child .content {margin: 0 10px;}
        .alert {color: red;font-weight: bold;}
        .child .pthumb img {max-width: 200px; min-height: 80px;}
        .child .thumb {float: left;}
        .child .thumb img {max-width: 90px;}
        .clear {clear: both !important;}
    </style>
  </head>
  <body>
    <div class="title">
      <h2>Cloud Hosting - Main </h2>
    </div>
EOF

@html_footer =<<EOF
  </body>
</html>
EOF

def convertXmlToHtml
  # Convert Main XML
  file_orig = @dest_dir + '/main.xml'
  file_dest = @dest_dir + '/main.html'

  doc = Nokogiri::XML(open(file_orig)) { |x| x.noblanks }
  File.open(file_dest, 'w+') do |fb|
    fb.write @html_header
    doc.root.children.each do |ch|
      hostname = ch.attr('hostname')
      web_path = hostname
      fb.write <<EOF
    <div class="child">
      <div class="title"><b>#{hostname}</b></div>
      <div class="content">
        <div>Date: #{Time.at(ch.attr('date').to_i)}</div>
        <div class="#{(ch.children[0].attr('default').to_i < ch.children[0].attr('current').to_i) ? 'alert' : ''}">Global - <b>#{ch.children[0].attr('current')}</b> --> #{ch.children[0].attr('default')}</div>
        <div class="#{(ch.children[1].attr('default').to_i < ch.children[1].attr('current').to_i) ? 'alert' : ''}">Web - <b>#{ch.children[1].attr('current')}</b> --> #{ch.children[1].attr('default')}</div>
        <div class="image pthumb"><a href="#{web_path + '/global_web.png'}" title="#{hostname} - global web"><img src="#{web_path + '/global_web.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/web_banda.png'}" title="#{hostname} - web banda"><img src="#{web_path + '/web_banda.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/web_cpu.png'}" title="#{hostname} - web cpu"><img src="#{web_path + '/web_cpu.png'}" /></a></div>
        <div class="clear"></div>
        <div class="image thumb"><a href="#{web_path + '/web_disk.png'}" title="#{hostname} - web disk"><img src="#{web_path + '/web_disk.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/web_io.png'}" title="#{hostname} - web io"><img src="#{web_path + '/web_io.png'}" /></a></div>
        <div class="clear"></div>
        <div class="image thumb"><a href="#{web_path + '/web_memory.png'}" title="#{hostname} - web memory"><img src="#{web_path + '/web_memory.png'}" /></a></div>
        <div class="clear"></div>

        <div class="#{(ch.children[2].attr('default').to_i < ch.children[2].attr('current').to_i) ? 'alert' : ''}">Email - <b>#{ch.children[2].attr('current')}</b> --> #{ch.children[2].attr('default')}</div>
        <div class="image pthumb"><a href="#{web_path + '/global_email.png'}" title="#{hostname} - global email"><img src="#{web_path + '/global_email.png'}" /></a></div>
        <div class="clear"></div>

        <div class="#{(ch.children[3].attr('default').to_i < ch.children[3].attr('current').to_i) ? 'alert' : ''}">Database - <b>#{ch.children[3].attr('current')}</b> --> #{ch.children[3].attr('default')}</div>
        <div class="image pthumb"><a href="#{web_path + '/global_database.png'}" title="#{hostname} - global database"><img src="#{web_path + '/global_database.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/db_cpu.png'}" title="#{hostname} - db cpu"><img src="#{web_path + '/db_cpu.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/db_disk.png'}" title="#{hostname} - db disk"><img src="#{web_path + '/db_disk.png'}" /></a></div>
        <div class="clear"></div>
        <div class="image thumb"><a href="#{web_path + '/db_io.png'}" title="#{hostname} - db io"><img src="#{web_path + '/db_io.png'}" /></a></div>
        <div class="image thumb"><a href="#{web_path + '/db_memory.png'}" title="#{hostname} - db memory"><img src="#{web_path + '/db_memory.png'}" /></a></div>
        <div class="clear"></div>

      </div>
    </div>
EOF
      #fb.write ch.to_xml
      # Convert specific XML
      current_dir = @dest_dir + '/' + hostname
      file_orig = current_dir + '/data.xml'
      file_dest = current_dir + '/data.html'

    end
    fb.write @html_footer
  end
end

convertXmlToHtml
