#!/usr/bin/perl
###################################################################################
#                                                                                 #
#                   PerlDesk - Customer Help Desk Software                        #
#                                                                                 #
###################################################################################
#                                                                                 #
#     Author: John Bennett	                                                      #
#      Email: j.bennett@perldesk.com                                              #
#        Web: http://www.perldesk.com                                             #
#   Filename: template.pl                                                         #
#    Details: The template parsing file for the user end                          #
#    Release: 1.5                                                                 #
#                                                                                 #
###################################################################################
# Please direct bug reports,suggestions or feedback to the perldesk forums.       #
# www.perldesk.com/board                                                          #
#                                                                                 #
# PerlDesk is free for both commercial and non-commercial use providing that the  #
# copyright headers remain intact and the links remain on the html pages.         #
# Re-distribution of this script without prior consent is strictly prohibited.    # 
#                                                                                 #
###################################################################################
# Please see the README/INSTALL files if you have any problems with this software #                                                            
###################################################################################

  %template = (
                 lang     => $language,
                 baseurl  => $global{'baseurl'},
                 imgbase  => $global{'imgbase'},
                 title    => $global{'title'},
                 timen    => $timenow,
                 mainfile => 'pdesk.cgi',
                 custom   => 'custom_value'            
             );


sub parse {

 my $file  = "@_";
    $file .= '.tpl';

 my $html;
 my $default;

 open MAIN, "include/tpl/default.tpl" || die "Error: $!";
   while (<MAIN>) {  $default .= $_; }
 close MAIN;

 open TPL, "$file" || die "Error opening $file: $!";
    while (<TPL>) {   $html  .= $_;  }
 close TPL;

 $default             =~  s/\{CONTENT\}/$html/g;

 $template{'usernav'} =   qq~<div align="center"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=main&lang=$template{'lang'}">$LANG{main}</a> | <a href="$template{'mainfile'}?do=submit_ticket&lang=$template{'lang'}"> $LANG{sreq}</a> | <a href="$template{'mainfile'}?do=listcalls&status=open&lang=$template{'lang'}"> $LANG{opencalls}</a> | <a href="$template{'mainfile'}?do=listcalls&status=closed&lang=$template{'lang'}">$LANG{closedcalls}</a> | <a href="$template{'mainfile'}?do=profile&lang=$template{'lang'}">$LANG{editprofile}</a></font></div>~;

 foreach my $key (keys %template) {
      $default =~ s/\{$key\}/$template{$key}/eg;
   }

   $default =~ s/\%(\S+)\%/$LANG{$1}/g;

     foreach $translation (@languages) 
        {
             my $name      =  $translation;
             $translation .=  '.gif';
             $htmlbar .= " <img src=$global{'imgbase'}/lang/$translation> <a href=\"$template{'mainfile'}?lang=$name\"><font size=1 face=Verdana, Arial, Helvetica, sans-serif>$langdetails{$name}</font></a>";
                
        }

    $default =~ s/\{languages\}/$htmlbar/g;
    script_error("You must leave the copyright information and link to perldesk, you are violating the license by removing them<br><br>It is possible to remove the links, for a fee of \$70 - <a href=http://perldesk.com/rlink.shtml>http://perldesk.com/rlink.shtml</a>") if $default !~ /perldesk\.com/i;
    return $default;

}


sub lang_parse {      
   $_ =~ s/\%(\S+)\%/$LANG{$1}/g;
}


1;