#!/usr/bin/perl
###################################################################################
#                                                                                 #
#                   PerlDesk - Customer Help Desk Software                        #
#                                                                                 #
###################################################################################
#                                                                                 #
#     Author: John Bennett	                                                      #
#      Email: j.bennett@perldesk.com                                              #
#        Web: http://www.perldesk.com                                             #
#   Filename: subs.cgi                                                            #
#    Details: The main user file                                                  #
#    Release: 1.5                                                                 #
#                                                                                 #
###################################################################################
# Please direct bug reports,suggestions or feedback to the perldesk forums.       #
# www.perldesk.com/board                                                          #
#                                                                                 #
# PerlDesk is free for both commercial and non-commercial use providing that the  #
# copyright headers remain intact and the links remain on the html pages.         #
# Re-distribution of this script without prior consent is strictly prohibited.    # 
#                                                                                 #
###################################################################################
# Please see the README/INSTALL files if you have any problems with this software #                                                            
###################################################################################  
 
   $use   = $q->cookie('id');
   $pas   = $q->cookie('pass');

   use vars qw/ $languages %global %LANG $q @languages $translation $language $hdtime $enablemail %template/;

   %Cookies = (
     id   => $use,
     pass => $pas
   );


sub check_user {

	if ((!$Cookies{'id'}) || ($Cookies{'id'} eq "") || (!$Cookies{'pass'}) || ($Cookies{'pass'} eq "")) {
          $ignore = 1;
          section("login"); 
 	}
    $statement = 'SELECT * FROM users WHERE username = ?'; 
    $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
    $sth->execute("$Cookies{'id'}") or die print "Couldn't execute statement: $DBI::errstr; stopped";
	  while(my $ref = $sth->fetchrow_hashref()) 
		{
	        $username             =   $ref->{'username'};
	        $password             =   $ref->{'password'};
	        $template{'company'}  =   $ref->{'company'};
	        $template{'fullname'} =   $ref->{'name'};
	        $template{'email'}    =   $ref->{'email'};
	        $template{'url'}      =   $ref->{'url'};
	        $template{'name'}     =   $ref->{'name'};
	        $rkey                 =   $ref->{'rkey'};
	    }

    my $md5 = new Digest::MD5 ;
	   $md5->reset ;

    my $yday   = (localtime)[7];
    my @ipa = split(/\./,$ENV{'REMOTE_ADDR'});
    my $startip = $ipa[0] . $ipa[1];
    my $certif = $Cookies{'id'} . "pd-$rkey" . $ENV{'HTTP_USER_AGENT'} . $startip;

       $md5->add($certif);

    my $enc_cert = $md5->hexdigest();

    if($enc_cert eq $Cookies{'pass'}) 
      {
   		# we're logged in !! :)
        $loggedin = 1;
      } 
         else {
                 $ignore = 1;
                  section("login");    	          
              } 

  my $time = time();
  my $sql  = 'SELECT active FROM users WHERE username = ?'; 
     $sth  = $dbh->prepare($sql) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
     $sth->execute("$Cookies{'id'}") or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
     {	
        $lastactive = $ref->{'active'};
     }

  }





sub lang_parse {
    if ($_ =~ /\%*\%/) 
           {
               s/\%(\S+)\%/$LANG{$1}/g;
           }
  }

sub lang_bar {

 if ($_ =~ /\{languages\}/) {

        my $querystring = $ENV{'QUERY_STRING'};
        my $and;
        my @htmllangbar;

        if ($querystring =~ /^lang/) { $querystring = ''; }

        $querystring =~ s/\&//g;
     if ($querystring) { $and = '&'; } else { $and =''; }
                 if ($and) 
                    { 
                        $querystring =~ s/lang=(.*)//g; 
                    }
     foreach $translation (@languages) 
        {
            $translation .= '.gif';
             my $htmlbar = " <img src=$global{'imgbase'}/lang/$translation> <a href=\"$ENV{'SCRIPT_NAME'}?$querystring" . "$and" . "lang=$translation\"><font size=1 face=Verdana, Arial, Helvetica, sans-serif>$langdetails{$translation}</font></a>";
             push @htmllangbar, $htmlbar;
        }
       s/\{languages\}/@htmllangbar/g;
   } else {
              s/\{languages\}//g;
          }   
   }


sub section {

  my $section = "@_";

  if ($section eq "main") {
     check_user();
     print "Content-type: text/html\n\n";

     $uname = $Cookies{'id'};
     my $sort;
     my $statement = 'SELECT * FROM announce WHERE users = "1"'; 
     my	$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
      while(my $ref = $sth->fetchrow_hashref()) 
      {	
          $notice .= ' <table width="100%" border="0" cellspacing="1" cellpadding="2"><tr><td width="5%"> <div align="center"><img src="' . "$global{'imgbase'}" . '/note.gif" width="11" height="11"></div></td><td width="62%"><a href="' . "$template{'mainfile'}" . '?do=notice&nid=' . "$ref->{'id'}&lang=$language\"><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">$ref->{'subject'}" . '</font></a></td><td width="33%"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">' . "$ref->{'time'}" . '</font></td></tr></table>';
      }
          $sth->finish;
          $notice = '<font face="verdana" size="1">No Announcements Set</font>' if !$notice;

      my $num  = 1;
         $sort = $q->param('sort') if defined $q->param('sort');
         $sort = "id" if !$sort; 

      my $method;

      if (defined $q->param('method')) { 
            if ($q->param('method') eq "asc") { $method = "ASC"; } else { $method = "DESC"; } 
       }
         else { $method = "ASC"; }

   my $sql = 'SELECT COUNT(*) FROM calls WHERE username = ? AND status != "CLOSED"'; 
      $sth = $dbh->prepare($sql) or die DBI->errstr;
	  $sth->execute("$Cookies{'id'}") or die print "Couldn't execute statement: $DBI::errstr; stopped";
		my ( $total ) = $sth->fetchrow_array();

         $limit = "20";  # Results per page

      my $pages = ($total/$limit);
         $pages = ($pages+0.5);
      my $nume  = sprintf("%.0f",$pages);

      my $page  = $q->param('page') || "0";
         $nume  = "1" if !$nume;
         $to    = ($limit * $page) if  $page;
         $to    = "0"              if !$page;

      foreach (1..$nume) 
          {       
             my $nu = $_ -1;
                  if ($nu eq $page) { $link = "[<b>$_</b>]"; } else { $link = "$_"; }          
             my $string =  $ENV{'QUERY_STRING'};
                $string =~ s/&page=(.*)//g;
              
                $nav .= qq|<font face="verdana" size="1"><a href="$template{'mainfile'}?$string&page=$nu">$link</a> </font>|;
           }

            $template{'nav'} = $nav;
         my $show  = $limit *  $page;

         $statement = 'SELECT * FROM calls WHERE username = "' . "$uname" . '" AND status != "CLOSED" ORDER BY ' . "$sort $method LIMIT $show, $limit"; 
         $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
         $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
             my $number=0;
      while(my $ref = $sth->fetchrow_hashref()) 
         {	
             my $img = "$global{'imgbase'}/mail.gif"   if $ref->{'method'} eq "em";
                $img = "$global{'imgbase'}/ticket.gif" if $ref->{'method'} ne "em";   

             my $bgcol;
             my $text = '#000000';
             if ($num == "2")   
                {
                      $bgcol   =  '#FFFFFF';
                      $num     = 0;
                }
                  else {
                         $bgcol   = '#F1F1F1';
                       }
            $number++;
            $listofcalls .= '  <table width="100%" border="0" cellspacing="1" cellpadding="3" align="center"><tr bgcolor="' . "$bgcol" . '"><td height="11" width="6%"><center>' . "<img src=\"$img\">" . '</center></td>
            				   <td height="11" width="6%"><font size="1" face="Verdana, Arial, Helvetica, sans-serif" color="' . "$text\"><a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\">$ref->{'id'}" . '</a></font></td>
            				   <td height="11" width="10%"><font size="1" face="Verdana" color="' . "$text\">$ref->{'status'}" . '</font></td>
                 			   <td height="11" width="9%"><font size="1" face="Verdana"></font><font size=1 face=Verdana color=' . "$text><div align=center>$ref->{'priority'}</div>" . '</font></td>
                   			   <td height="11" width="45%"><a href="' . "$template{'mainfile'}" . '?do=view&cid=' . "$ref->{'id'}\&lang=$language" . '"><font size=1 face=Verdana color=' . "$text>$ref->{'subject'}" . '</a></font></td>
            				   <td height="11" width="24%"><font size=1 face=Verdana color=' . "$text>$ref->{'time'}" . '</font></td></tr></table>';
            $num++;
            $to++;
     	}
            $sth->finish;

        if (! $listofcalls)  
          {
                           $listofcalls = '<table width="100%" border="0" cellspacing="1" align="center">
                                           <tr bgcolor="#FBFBFB"><td height="11" colspan="5"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">0 
                                           ' . "$LANG{'request'}" . '</font></td></tr></table>';
          }
 
         my $opencalls = "<font size=2>$LANG{'inindex1'} <b>$total</b> $LANG{'inindex2'}.</font><br>";
        
        $template{'from'}         = $limit * $page;
        $template{'to'}           = $to; 
        $template{'total'}        = $total;
        $template{'announcement'} = $notice;
        $template{'numcalls'}     = $opencalls;
        $template{'listofcalls'}  = $listofcalls;

         my $output = parse("$global{'data'}/include/tpl/membermain");
      print $output;
 
 }

 if ($section eq "lpass") {
       print "Content-type: text/html\n\n";
       my $output = parse("$global{'data'}/include/tpl/resetpass");
       print $output;

   }

 if ($section eq "emailreq") {

       check_user();

         $template{'trackno'} = $q->param('cid');

       print "Content-type: text/html\n\n";

        my $output = parse("$global{'data'}/include/tpl/emailreq");
        print $output;

  }


 if ($section eq "emailreqsend") {

       check_user();
       my $trackno = $q->param('id');
          
 print "Content-type: text/html\n\n";
       
 my $email = $q->param('email');    
 my $id    = $q->param('id');
 
 die_nice("No Ticket Specified") if !$id;

 $statement = 'SELECT * FROM calls WHERE  id = ?'; 
   $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
   $sth->execute($id) or die print "Couldn't execute statement: $DBI::errstr; stopped";
      $number=0;
          while(my $ref = $sth->fetchrow_hashref()) {	

           if (($ref->{'username'} != $Cookies{'id'}) || ($ref->{'owner'})) 
             {
                 die_nice("ERROR: You are not authorised to view this call!");
             }			

			$trackno     =  $ref->{'id'};
			$date        =  $ref->{'time'};
			$username    =  $ref->{'username'};
			$priority    =  $ref->{'priority'};
			$status      =  $ref->{'status'};
			$subject     =  $ref->{'subject'};
			$category    =  $ref->{'category'};
			$description =  $ref->{'description'};
			$owner       =  $ref->{'ownership'};
			$number      =  0;
			$url         =  $ref->{'url'};
			$name        =  $ref->{'name'};
       }

$body .= qq|
Below is a copy of your request, including any user/staff responses:

----------------------------------------------------------
REQUEST $id
----------------------------------------------------------  

STATUS....: $status 
LOGGED....: $date
SUBJECT...: $subject                 

----------------------------------------------------------
$description
---------------------------------------------------------- 
|;

	$statemente = 'SELECT * FROM notes WHERE `call` = ? ORDER BY id;'; 
	$sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	$sth->execute($id) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	      while(my $ref = $sth->fetchrow_hashref()) {
				$cbody = $ref->{'comment'};
                $cbody =~ s/<br>/\n/g;
                $body .= qq|
:: RESPONSE $ref->{'author'} ($ref->{'time'})
$cbody
---------------------------------------------------------- 

|;
 
  }
  
  email( To => "$email", From => "$global{'adminemail'}", Subject => "Support Request $id", Body => "$body");
       
    	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$id"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, a copy of this request has been emailed to $email.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$id">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
  }

 if ($section eq "setpass") {

     $username  =  $q->param('username');
     $email     =  $q->param('email');
     $statement = 'SELECT * FROM users WHERE username = ?'; 
     $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
     $sth->execute($username) or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
     {	
         $name  = $ref->{'name'};
         $uname = $ref->{'username'};
         $salt  = $ref->{'rkey'};

         if ($email ne $ref->{'email'}) 
           {
             $error .= "Email/Username combination invalid";
          }
     }
     $sth->finish;

     if (!$uname) 
      {
         $error .= "Username does not exist";
      }

    die_nice("$error") if $error;
 
	my @chars=(A..Z);
	my $pass= $chars[rand(@chars)] . $chars[rand(@chars)] . $chars[rand(@chars)] . $chars[rand(@chars)] . $chars[rand(@chars)] . $chars[rand(@chars)];
	my $password = crypt($pass, $salt);	
	
	$statementd = 'UPDATE users SET password = "' . "$password" . '" WHERE username = "' . "$username" . '";'; 
	 $sth = $dbh->prepare($statementd) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    $sth->finish;

    my $subject = "Support Password";

    	open (MAILNEWTPL,"$global{'data'}/include/tpl/newpass.txt");
          while (<MAILNEWTPL>) 
               {
                    lang_parse();
      				  if ($_ =~ /\{*\}/i) 
                       { 
				        	s/\{baseurl\}/$global{'baseurl'}/g;
				        	s/\{name\}/$name/g;
				        	s/\{username\}/$username/g;
				        	s/\{password\}/$pass/g;
                            s/\{mainfile\}/$template{'mainfile'}/g;
				       }			
                   $body .= $_;
               }
           close(MAILNEWTPL);	

         email ( To => "$email", From => "$global{'adminemail'}", Subject => "$subject", Body => "$body" );
         print "Content-type: text/html\n\n";  
         my $output = parse("$global{'data'}/include/tpl/emailedpass");
         print $output;
  }

if ($section eq "closereq") {

   check_user();
   print "Content-type: text/html\n\n";

   my $trackno             =  $q->param('id');
      $template{'trackno'} =  $trackno;
   my $output              =  parse("$global{'data'}/include/tpl/closereq");
   print $output;

  exit;
}

if ($section eq "closesave") {

   check_user();
 
   print "Content-type: text/html\n\n";

  $callid    =  $q->param('id');
  $comments .=  "[b]TICKET CLOSED BY USER[/b]<br>";
  $comments .=  $q->param('reason'); 
 
    my $rv = $dbh->do(qq{INSERT INTO notes values (
        "NULL", "0", "1", "CLOSED", "$callid", "$Cookies{'id'}", "$hdtime", "$comments")}
   );

   $statement = 'UPDATE calls SET status = "CLOSED" WHERE id = ?'; 
   $sth       = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
   $sth->execute($callid) or die print "Couldn't execute statement: $DBI::errstr; stopped";

     	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$callid"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, this request has now been closed.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$callid">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
 }


if ($section eq "reopen") 
 {

    check_user();
    print "Content-type: text/html\n\n";

     my $trackno             =  $q->param('id');
        $template{'trackno'} =  $trackno;
     my $output              =  parse("$global{'data'}/include/tpl/reopen");
  
    print $output;

    exit;
 }

if ($section eq "re_open") {

   check_user();
 
   print "Content-type: text/html\n\n";

  $callid    =  $q->param('id');
  $comments .=  "[b]TICKET RE-OPENED BY USER[/b]<br>";
  $comments .=  $q->param('reason'); 
 
    my $rv = $dbh->do(qq{INSERT INTO notes values (
        "NULL", "0", "1", "RE-OPEN", "$callid", "$Cookies{'id'}", "$hdtime", "$comments")}
   );

   $statement = 'UPDATE calls SET status = "OPEN" WHERE id = ?'; 
   $sth       = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
   $sth->execute($callid) or die print "Couldn't execute statement: $DBI::errstr; stopped";

     	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$callid"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, this request has now been re-opened.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$callid">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
}

if ($section eq "changepri") 
 {
    check_user();
    print "Content-type: text/html\n\n";

     $callid     =  $q->param('cid');
     $statemente = 'SELECT * FROM calls WHERE id = ?'; 
	 $sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	 $sth->execute($callid) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	   while(my $ref = $sth->fetchrow_hashref()) 
         {
			if (($ref->{'username'} != $Cookies{'id'}) || ($ref->{'owner'})) 
			{
				die_nice("ERROR: You are not authorised to edit this call!");
				
			} 
       		   $priority = $ref->{'priority'};
         }
       $response = '<form action="' . "$template{'mainfile'}" . '" method="post"><table width="60%" border="0" align="center"><tr><td width="44%">&nbsp;</td>
            		<td width="21%">&nbsp;</td><td width="35%">&nbsp;</td></tr><tr><td width="44%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>' . "$LANG{'update'}" . ' 
              		' . "$LANG{'priority'}" . '</b></font></td><td colspan="2"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"> 
              		<div align=center><select name="priority"  style="font-size: 12px"><option value="1">1 - Urgent</option>
                	<option value="2">2</option><option value="3" selected>3</option><option value="4">4</option><option value="5">5 - Inquiry</option></select></div></font></td></tr><tr><td width="44%">&nbsp;</td>
            		<td colspan="2">&nbsp;</td></tr><tr><td colspan="3"><div align="center"><input type="hidden" name="do" value="savepri"><input type="hidden" name="ticket" value="' . "$callid" . '"><input type="submit" name="Submit2" value="Submit">
              		</div></td></tr></table></form>';

      $template{'response'}  = $response;

      my $output = parse("$global{'data'}/include/tpl/general");
      print $output;
}


if ($section eq "savepri") 
 {
    check_user(); 
    print "Content-type: text/html\n\n";

    my $ticket    = $q->param('ticket');
    my $priority  = $q->param('priority');

    $statement = 'UPDATE calls SET priority = "' . "$priority" . '" WHERE id = "' . "$ticket" . '";'; 
	$sth       = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";

     	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$ticket"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, the priority of this request has been updated.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$ticket">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
 }

if ($section eq "login") 
  {

    if ($ignore != "1") 
     {
          check_user();
          print "Location: $global{'baseurl'}/$template{'mainfile'}?do=main\n\n" if $loggedin == "1";
          exit;
      }

    print "Content-type: text/html\n\n";
    print parse("$global{'data'}/include/tpl/login");
    
   exit;

  }

if ($section eq "register")  
 {
    print "Content-type: text/html\n\n";
    my $output = parse("$global{'data'}/include/tpl/register");
    print $output;
 }

if ($section eq "submit_req") 
 {

    check_user(); 

   my $subject     = $q->param('subject');
   my $description = $q->param('description');
   my $username    = $q->param('username');
   my $priority    = $q->param('priority');
   my $category    = $q->param('category');

   if (($subject eq "") || ($description eq "")) 
      {
         die_nice("<font face=Verdana size=2>$LANG{'error1'}</font>");
      }

    my $statement = 'SELECT email FROM users WHERE username = ?'; 
    my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
       $sth->execute( $Cookies{'id'} ) or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
      {	
          $email = $ref->{'email'};
      }
    $sth->finish;


    $current_time = time();
	$statement    = qq|SELECT lcall FROM users WHERE username = "$Cookies{'id'}"|; 
		$sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
     {
          my $newtime = $ref->{'lcall'};
             $newtime = $newtime + $global{'floodwait'};
      
             die_nice("You can only log a call every $global{'floodwait'} seconds") if $newtime > $current_time;
     }

   my $edescription = $description;
      $description  =~ s/</&lt;/g;
      $description  =~ s/>/&gt;/g;
         
   my $dsth = $dbh->prepare( "INSERT INTO calls VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" );
      $dsth->execute( "NULL", "OPEN", $username, $email, $priority, $category, $subject, $description, $hdtime, "Unowned", "NULL", "hd", $current_time, $current_time, "1", "0" );
        
	  $callid = $dbh->{'mysql_insertid'}; 

    my $statement = 'SELECT * FROM ticket_fields ORDER BY dorder'; 
    my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
       $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
      {	
         my $fid = $ref->{'id'};
         my $sth = $dbh->prepare( "INSERT INTO call_fields VALUES ( ?, ?, ?, ? )" ) or die $DBI->errstr;
            $sth->execute( "NULL", $callid, "$fid", $q->param($fid) ) or die $DBI->errstr;              
      }
    $sth->finish;

    $dbh->do(qq|UPDATE users SET lcall = "$current_time" WHERE username = "$Cookies{'id'}"|);

	$statement = 'SELECT * FROM staff WHERE access LIKE "%' . "$category" . '::%" OR access LIKE "%GLOB::%" OR access = "admin";'; 
		$sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) {

     if ($ref->{'notify'} == "1") {
      if ($enablemail) {

        my $to       = $ref->{'email'};
        my $from     = $global{'adminemail'};
        my $esubject = "New Help Desk Request";
        my $msg      = qq|
There is a new help desk submission

Ticket Details
------------------------------------------
Ticket ID.............: $callid
Logged by.............: $Cookies{'id'}
Category..............: $category
Subject...............: $subject

$edescription

------------------------------------------

URL: $global{'baseurl'}/staff.cgi?do=login

Thank You
|;
       email ( To => "$to", From => "$from", Subject => "$esubject", Body => "$msg" );
      } }
    }
	$sth->finish;
	close (MAILNEWTPL);
	$content = "<font size=2><b>$LANG{'thankyou'}</b><br><br>$LANG{'subrec'} <a href=$template{'mainfile'}?do=main>$LANG{'subrec2'}</a>";

    if ($enablemail) 
     {
       my $body;
			open (MAILNEWTPL,"$global{'data'}/include/tpl/newticket.txt");
				while (<MAILNEWTPL>) {
                  lang_parse() if $_ =~ /%*%/;
				  if ($_ =~ /\{*\}/i) 
                    { 
     					s/\{baseurl\}/$global{'baseurl'}/g;
    					s/\{name\}/$Cookies{'id'}/g;
    					s/\{subject\}/$subject/g;
    					s/\{description\}/$description/g;
    					s/\{mainfile\}/$template{'mainfile'}/g;
                     	s/\{lang\}/$language/g;
    					s/\{date\}/$hdtime/g;
    				}			
                		$body .= "$_";
        		  }
           	close(MAILNEWTPL);

        my $subject = "\{$global{'epre'}-$callid\} Help Desk Submission";
           email ( To => "$email", From => "$global{'adminemail'}", Subject => "$subject", Body => "$body" );
      }	

     $template{'response'} = $content;
 
     print "Content-type: text/html\n\n";
     print parse("$global{'data'}/include/tpl/general");
  }


if ($section eq "logout")  
 {

     check_user();

     $cookie1 = $q->cookie(-name=>'id',
                           -value=>'',
                           -path    =>  '/',
                           -domain  =>'');
     $cookie2 = $q->cookie(-name=>'pass',
                           -value=>'',
                           -path    =>  '/',
                           -domain =>'');
 
     print $q->header(-cookie=>[$cookie1,$cookie2]);

     my $response = "<b><font size=2>$LANG{'loggedout'}. <a href=$template{'mainfile'}?do=login>$LANG{'logbackin'}</a></font></b>";
        $template{'response'} = $response;

     my $output = parse("$global{'data'}/include/tpl/general");
     print $output;
  }


if ($section eq "notice") {

    check_user();
    print "Content-type: text/html\n\n";
    
    my $notice = $q->param('nid');
	$statement = 'SELECT * FROM announce WHERE users = "1" AND id = ?'; 
	$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	$sth->execute($notice) or die print "Couldn't execute statement: $DBI::errstr; stopped";
     while(my $ref = $sth->fetchrow_hashref()) 
      {	
        $notices .= '<table width="100%" border="0" cellspacing="1" cellpadding="0">
               		 <tr><td width="24%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$LANG{'author'}" . ':</font></td><td width="76%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$ref->{'author'}" . '</font></td>
              		 </tr><tr><td width="24%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$LANG{'time'}" . ':</font></td><td width="76%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$ref->{'time'}" . '</font></td>
              		 </tr><tr><td width="24%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"></font></td><td width="76%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"></font></td>
              		 </tr><tr><td width="24%" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$LANG{'subject'}" . ':</font></td><td width="76%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>' . "$ref->{'subject'}" . '</b><br><br></font></td>
              		 </tr><tr><td width="24%" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$LANG{'announcement'}" . ':</font></td><td width="76%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">' . "$ref->{'message'}" . '</font></td></tr></table>';

      }
       $template{'announcement'} = $notices;
      my $output = parse("$global{'data'}/include/tpl/announcement");
      print $output;

  }

if ($section eq "listcalls") {

    check_user();
    print "Content-type: text/html\n\n";
    my $num    =  1;
    my $status =  $q->param('status');
	my $type   =  $status;

    if (defined $q->param('sort')) 
      { 
         $sort = $q->param('sort');
      }   
     else {
             $sort = "id"; 
          }

     if (defined $q->param('method')) 
       { 
            if ($q->param('method') eq "asc") { $method = "ASC"; } else { $method = "DESC"; } 
       }
        else { 
                $method = "ASC"; 
             }
  

   my $sql = 'SELECT COUNT(*) FROM calls WHERE username = ? AND status != "CLOSED"' if $status eq "open"; 
      $sql = 'SELECT COUNT(*) FROM calls WHERE username = ? AND status = "CLOSED"'  if $status eq "closed"; 
  
   my $threaded = $q->param('threaded');

      $sth = $dbh->prepare($sql) or die DBI->errstr;
	  $sth->execute("$Cookies{'id'}") or die print "Couldn't execute statement: $DBI::errstr; stopped";
		my ( $total ) = $sth->fetchrow_array();

         $limit = "20";  # Results per page

      my $pages = ($total/$limit);
         $pages = ($pages+0.5);
      my $nume  = sprintf("%.0f",$pages);
      my $page  = $q->param('page') || "0";
         $nume  = "1" if !$nume;
         $to    = ($limit * $page) if  $page;
         $to    = "0"              if !$page;

      foreach (1..$nume) 
          {       
             my $nu = $_ -1;
                  if ($nu eq $page) { $link = "[<b>$_</b>]"; } else { $link = "$_"; }          
             my $string =  $ENV{'QUERY_STRING'};
                $string =~ s/&page=(.*)//g;
                $nav   .= qq|<font face="verdana" size="1"><a href="$template{'mainfile'}?$string&page=$nu">$link</a> </font>|;
           }

            $template{'nav'} = $nav;
         my $show  = $limit *  $page;

      $statemente = qq|SELECT * FROM calls WHERE username = ? AND status != "CLOSED" ORDER BY $sort $method LIMIT $show, $limit| if $status eq "open"; 
      $statemente = qq|SELECT * FROM calls WHERE username = ? AND status = "CLOSED" ORDER BY $sort $method LIMIT $show, $limit| if $status eq "closed"; 

      $sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
      $sth->execute("$Cookies{'id'}") or die print "Couldn't execute statement: $DBI::errstr; stopped";
      while(my $ref = $sth->fetchrow_hashref()) {
     
         my $img = "$global{'imgbase'}/mail.gif"   if $ref->{'method'} eq "em";
            $img = "$global{'imgbase'}/ticket.gif" if $ref->{'method'} ne "em"; 
         my $text = '#000000';
		 my $subject = $ref->{'subject'}; 
		    $subject = substr($subject,0,20).'..' if length($subject) > 22;     

       if ($threaded) { $bgcol = '#FOFOFO'; }
       else {
 		 if ($num eq "2") 
             {
      			$bgcol = '#FFFFFF';
    			$num = 0;
     	 	 }
               else {
			           $bgcol = '#F0F0F0';
             	  	}
         }
         		$listofcalls .= '<table width="100%" border="0" cellspacing="1" cellpadding="4" align="center"><tr bgcolor="' . "$bgcol". '"><td height="11" width="5%"><center>' . "<img src=\"$img\">" . '</center></td><td height="11" width="7%"><font size="1" face="Verdana, Arial, Helvetica, sans-serif" color="' . "$text\"><a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\">$ref->{'id'}" . '</a></font></td>
         					     <td height="11" width="10%"><font size="1" face="Verdana" color="' . "$text\">$ref->{'status'}" . '</font></td><td height="11" width="9%"><font size="1" face="Verdana"></font><font size=1 face=Verdana color=' . "$text><div align=center>$ref->{'priority'}</div>" . '</font></td>
            				     <td height="11" width="45%">' . "<a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\&lang=$language\">" . '<font size=1 face=Verdana color=' . "$text>$subject" . '</a></font></td>
        					     <td height="11" width="24%"><font size=1 face=Verdana color=' . "$text>$ref->{'time'}" . '</font></td></tr></table>';
               if ($threaded) 
                 {
                         my $sql = qq|SELECT * FROM notes WHERE `call` = $ref->{'id'} ORDER BY id|; 
	                        $ssth = $dbh->prepare($sql) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
                          	$ssth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";       
                	      while(my $sref = $ssth->fetchrow_hashref()) {
       
                           $sref->{'comment'} =~ s/\n//;

                           my $comment   =  substr($sref->{'comment'},0,54);
                              $comment  .=  '....' if length($sref->{'comment'}) > 54;
                              $comment   =~ s/\[b\]//g; 
                              $comment   =~ s/\[\/b\]//g;
                              $comment   =~ s/<br>//g;  
                      
                           $listofcalls .= qq~<table width="100%" border="0" cellpadding="1" cellspacing="1"><tr><td width="5%" bgcolor="#FFFFFF"></td>
                                              <td width="7%" bgcolor="#F9F9F9"><font size="1" face="Arial, Helvetica, sans-serif"><div align="center">[ - ]</div></font></td>
                                              <td width="19%" bgcolor="#F9F9F9"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$ref->{'id'}&lang=$language#$sref->{'id'}"><font color="#000000">$sref->{'author'}</font></a></font></td>
                                              <td width="69%" bgcolor="#F9F9F9"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$ref->{'id'}&lang=$language#$sref->{'id'}"><font color="#000000">$comment</font></a></font></td></tr></table>~;
                      }   
                   }
                     $num++;
		             $to++;
          		}

	if (! $listofcalls) 
         {
	          	$listofcalls = '<table width="100%" border="0" cellspacing="1" align="center">
                              	<tr bgcolor="#FBFBFB"><td height="11" colspan="5"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">0 Tickets</font></td></tr></table>';
		 }


    my $pm  = '-' if  $threaded;
       $pm  = '+' if !$threaded;

    my $inm  = 'COLLAPSE' if $threaded;
       $inm  = 'EXPAND'  if !$threaded;


    my $val = '0' if  $threaded;
       $val = '1' if !$threaded;
       $template{'path'} =  $template{'mainfile'} . '?' . $ENV{'QUERY_STRING'};

    $template{'path'} =~ s/&sort=(.*)//;
    $template{'path'} =~ s/&method=(.*)//;
   
    $ENV{'QUERY_STRING'} =~ s/&threaded=0//;
    $ENV{'QUERY_STRING'} =~ s/&threaded=1//;

    my $url = qq~<a href="$template{'mainfile'}?$ENV{'QUERY_STRING'}&threaded=$val">$inm ($pm)</a>~;

    $template{'url'}         =   $url;
    $template{'from'}        =   $page * $limit;
    $template{'to'}          =   $to;
    $template{'total'}       =   $total;
    $template{'listofcalls'} =   $listofcalls;
    $template{'text'}        =   $texti;
    $template{'type'}        =   $type;

   my $output = parse("$global{'data'}/include/tpl/list");
   print $output;

  }


if ($section eq "profile") 
 {
     check_user();

     print "Content-type: text/html\n\n";
     print parse("$global{'data'}/include/tpl/profile");
 
  }

if ($section eq "update_profile") {

   check_user();

   my (@errors);
   my ($error);
   my ($password);

     $name   =   $q->param('name');
     $email  =   $q->param('email');
     $url    =   $q->param('url');
     $pass1  =   $q->param('pass1');
     $pass2  =   $q->param('pass2');

   if (!$name) 
     {
		$error = "$LANG{'error5'} name";
	    push (@errors, $error);
 	 }
   elsif (!$email)
    {
		$error = "$LANG{'error5'} email address";
   	push(@errors,$error);
	}
    elsif (!$url) 
      {
		$error = "$LANG{'error5'} URL";
    	push(@errors,$error);
	  } 
    elsif ($pass1 ne $pass2)	
      {
       		$error = "The passwords specified do not match";
          	push(@errors,$error);
      }
 
	if (@errors) {
			print "Content-type: text/html\n\n";
            print @errors;
     	exit;	
 	}


    if (!@errors) {

     print "Content-type: text/html\n\n";

     $dbh->do(qq|UPDATE users SET name = "$name", email = "$email", url = "$url" WHERE username = "$Cookies{'id'}"|);

	 $statemente = 'SELECT * FROM users WHERE username = "' . "$Cookies{'id'}" . '"'; 
	 $sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
        while(my $ref = $sth->fetchrow_hashref()) {
			if ($ref->{'password'} ne $cpass) {

				if (($pass1) && ($pass2)) {

					my @chars=(A..Z);

					$salt= $chars[rand(@chars)] . $chars[rand(@chars)];
					$cpass = crypt($pass1, $salt);	

					$statementd = 'UPDATE users SET password = "' . "$cpass" . '", rkey = "' . "$salt" . '" WHERE username = "' . "$Cookies{'id'}" . '";'; 
					$sth = $dbh->prepare($statementd) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
					$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
			}	}
		}

      $response = "<div align=left><font face=Verdana size=2>$LANG{'thankyou'}.<br><br>$LANG{'profileup'}<br><br>Please <a href=\"$global{'mainfile'}?do=login\">$LANG{'login'}</a>";

      $template{'response'} = $response;
      my $output = parse("$global{'data'}/include/tpl/general");
      print $output;
  } }


if ($section eq "search") 
  {

    check_user();

	$select = $q->param('select');
	$query  = $q->param('query');

	if ($select eq "id")	   { 	$field = "id"; 			}
	if ($select eq "status")   {    $field = "status"; 	    }
	if ($select eq "subject")  { 	$field = "subject"; 	}
	if ($select eq "comments") { 	$field = "description"; }

    $feld   =  $q->param('field');
    $query  =  $q->param('query');

	$query =~ s/_/ /g;

	if (!$feld) {	$feld = $field;   } 

    if (defined $q->param('sort')) 
       { 
         $sort = $q->param('sort');
       }   
         else { 
                $sort = "id"; 
              }

    if (defined $q->param('method')) 
       { 
           if ($q->param('method') eq "asc") { $method = "ASC"; } else { $method = "DESC"; } 
       }
         else { 
                 $method = "ASC"; 
              }

if ($query) {

	$showp =  0*30;
    $num   =  1;
    
    $statement = 'SELECT COUNT(*) FROM calls WHERE ' . "$feld" . ' LIKE "%' . "$query" . '%" AND username = "' . "$Cookies{'id'}" . '"';
	$sth = $dbh->prepare($statement) or die print DBI->errstr;
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
       $count = $sth->fetchrow_array();
    $sth->finish;

	 $statement = 'SELECT * FROM calls WHERE  ' . "$feld" . ' LIKE "%' . "$query" . '%" AND username = "' . "$Cookies{'id'}" . '" ORDER BY '. "$sort $method" . ' LIMIT ' . "$showp" . ',30'; 
	 $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		$number=0;
	 while(my $ref = $sth->fetchrow_hashref()) {	
		$number++;
			    $font = '#000000';
	
				$subject="$ref->{'subject'}"; 
				$subject=substr($subject,0,20).'..' if length($subject) > 22;
								if ($ref->{'method'} eq em) {  
									 $img = "$global{'imgbase'}/mail.gif";
								} else { 
									 $img = "$global{'imgbase'}/ticket.gif";
								}
      if ($num eq "2") 
        {
			$bgcol = '#FFFFFF';
			$num = 0;
	     } else {
	         		$bgcol = '#F0F0F0';
             	}

      if  ($feld eq "description")
         {
           $link = "&highlight=$query";
         }

         $link = "" if !$link; 

		        $opencalls .= '<table width="100%" border="0" cellspacing="1" cellpadding="4" align="center"><tr bgcolor="' . "$bgcol". '"><td height="11" width="5%"><center>' . "<img src=\"$img\">" . '</center></td>
   					<td height="11" width="7%"><font size="1" face="Verdana, Arial, Helvetica, sans-serif" color="' . "$text\"><a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\">$ref->{'id'}" . '</a></font></td>
   					<td height="11" width="10%"><font size="1" face="Verdana" color="' . "$text\">$ref->{'status'}" . '</font></td>
    				<td height="11" width="9%"><font size="1" face="Verdana"></font><font size=1 face=Verdana color=' . "$text><div align=center>$ref->{'priority'}</div>" . '</font></td>
    				<td height="11" width="45%">' . "<a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\&lang=$language$link\">" . '<font size=1 face=Verdana color=' . "$text>$subject" . '</a></font></td>
   					<td height="11" width="24%"><font size=1 face=Verdana color=' . "$text>$ref->{'time'}" . '</font></td></tr></table>';

                $num++;
		}
	$sth->finish;

} else { 
               $opencalls = qq|<font face="Verdana" size="2">You must enter a search term</font>|;
               $count     = 0;
       }

    $template{'field'}     = $feld;
    $template{'query'}     = $query;
    $template{'results'}   = $opencalls;
    $template{'noresults'} = $count;
    $template{'bar'}       = $bar;

     print "Content-type: text/html\n\n";

     my $output = parse("$global{'data'}/include/tpl/results");
     print $output;
  }


if ($section eq "activate") {

   my $user      = $q->param('uid');
   my $code      = $q->param('key');

   my $statement = 'SELECT * FROM users WHERE id = ?'; 
   my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
      $sth->execute($user) or die print "Couldn't execute statement: $DBI::errstr; stopped";
 	while(my $ref = $sth->fetchrow_hashref()) 
      {
         $scode    =  $ref->{'acode'};
         $username =  $ref->{'username'};
         $email    =  $ref->{'email'};
         $name     =  $ref->{'name'};
      }
 

   $template{'user'}     = $username;
   $template{'username'} = $username;
   $template{'password'} = '(not shown)';
   $template{'cname'}    = $name;

   die_nice("This account is already activate") if !$scode;
   die_nice("Invalid Activation Key") if $scode != $code;
  
   my $page = qq~ <b>Thank You</b><br>The account <b>$username</b> has been activated ~;

      $dbh->do(qq|UPDATE users SET acode = "0" WHERE id = "$user"|);

        print "Content-type: text/html\n\n";

      	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="3;URL=$template{'mainfile'}?do=login"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thank You</b>, the account <i>$username</i> has now been activated.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=login">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;

  if ($enablemail) 
   {
        my $body;
		open (MAILTPL, "$global{'data'}/include/tpl/welcome.txt");
			while (<MAILTPL>) 
                {
                    lang_parse() if $_ =~ /%*%/;
                     s/\{(\S+)\}/$template{$1}/g;
        		    $body .= $_;
			    }  
		close(MAILTPL);	
        email ( To => "$email", From => "$global{'adminemail'}", Subject => "Help Desk Registration", Body => "$body" );
   }


}


if ($section eq "pro_login") {
    $pass = $q->param('password');
    $user = $q->param('username');

    # by Ago
    &identity_control($user);
    # fine by Ago


    my ( $DBUSER,      # DB Username
         $DBNAME,      # DB Name
         $DBEMAIL,     # DB E-mail
         $DBURL        # DB URL
       );
 
    my $salt;
    my $statement = 'SELECT * FROM users WHERE username = ?'; 
    my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
      $sth->execute($user) or die print "Couldn't execute statement: $DBI::errstr; stopped";
 	while(my $ref = $sth->fetchrow_hashref()) 
      {

         die_nice("Invalid Username (case sensitive)") if $user ne $ref->{'username'};

          $salt  = $ref->{'rkey'};
       my $cpass = crypt($pass, $salt); 

       if ($cpass ne $ref->{'password'}) 
         {
				die_nice("Invalid Password");
         }
           else {
			      $DBUSER   = $ref->{'username'};
			      $DBNAME   = $ref->{'name'};
			      $DBEMAIL  = $ref->{'email'};
			      $DBURL    = $ref->{'url'};
                  $status   = $ref->{'pending'};
                  $code     = $ref->{'acode'};
		        } 		
     }

    $template{'name'}  = $DBUSER;
    $template{'user'}  = $DBUSER;
    $template{'email'} = $DBEMAIL;
    $template{'url'}   = $DBURL;

    die_nice("$LANG{'error6'}") if !$DBUSER;
    die_nice("The administrator has chosen to approve accounts before they become active. An email will be sent to you when this account is activated.") if $status eq "1";
    die_nice("You need to activate your account by clicking the link in the email sent to $DBEMAIL before you can access your account") if $code;

	my $md5 = new Digest::MD5 ;
	   $md5->reset ;

    my $yday    = (localtime)[7];
    my @ipa     = split(/\./,$ENV{'REMOTE_ADDR'});
    my $startip = $ipa[0] . $ipa[1];
    my $certif  = $user . "pd-$salt" . $ENV{'HTTP_USER_AGENT'} . $startip;
       $md5->add($certif);

 	$enc_cert = $md5->hexdigest() ;
    $sth->finish;

    my $cookie1; 
    my $cookie2;

    $time = time();
  
    $dbh->do(qq|UPDATE users SET active = "$time" WHERE username = "$user"|);
    
    if ($q->param('remember') eq "yes") 
          {

               $cookie1 = $q->cookie(  -name=>'id',
                                       -value=>$user,
                                       -path    =>  '/',
                                       -domain  =>'',
                                       -expires=>'+1y'
                                    );
               $cookie2 = $q->cookie(  -name=>'pass',
                                       -value=>$enc_cert,
                                       -path    =>  '/',
                                       -domain  =>'',
                                       -expires=>'+1y'
                                    );

           } else {
                    $cookie1 = $q->cookie(  -name=>'id',
                                            -value=>$user,
                                            -path    =>  '/',
                                            -domain  =>''
                                         );
                    $cookie2 = $q->cookie(  -name=>'pass',
                                            -value=>$enc_cert,
                                            -path    => '/',
                                            -domain =>''
                                         );
                  }
         
        print $q->header(-cookie=>[$cookie1,$cookie2]);

        my $lang = $q->param('lang');

      	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=main&lang=$lang"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Thanks for logging in</b>, you are now being taken to the members area.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=main&lang=$lang">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;

    }


if ($section eq "submit_ticket") 
 {

    check_user();
    print "Content-type: text/html\n\n";

    my $statement = 'SELECT * FROM ticket_fields ORDER BY dorder'; 
    my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
       $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
      {	
          $template{'form'} .= qq|<tr><td width="24%"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">$ref->{'name'}</font></td><td width="76%"> <font size="2" face="Verdana, Arial, Helvetica, sans-serif"> 
                                  <input type="text" class="tbox"  name="$ref->{'id'}" value="$ref->{'value'}" size="35"></font></td></tr>
                                 |;
      }
    $sth->finish;

    my $statement = 'SELECT level FROM departments'; 
    my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
       $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
    while(my $ref = $sth->fetchrow_hashref()) 
      {	
           $option .= "<option value=\"$ref->{'level'}\">$ref->{'level'}</option>";
      }
    $sth->finish;

    $template{'category'} = $option;
    $template{'uname'}    = $Cookies{'id'};

     my $output = parse("$global{'data'}/include/tpl/submitreq");
     print $output;

  }

if ($section eq "calender") 
 {

   check_user();

   if ($q->param('goto'))
      {
          if ($q->param('goto') eq "viewday")
               {
                    $day_no = $q->param('day');
               }
      }

  $day_no  = $q->param('day');
  $date_no = $day_no if $day_no;

  my @monthnames = qw(January February March April May June July August September October November December);
  my $prevmonth  = '&laquo;';
  my $nextmonth  = '&raquo;';

  my @dayabbrev = qw(S M T W T F S);
  my $daywidth = 20;      # per-column pixel width

  my $html = "";

  $day_no = $date_no if !$day_no; 

  $cmonth = $q->param('month') if defined $q->param('month');
  $cyear  = $q->param('year')  if defined $q->param('year');
  $cmonth = $month_no if !$cmonth;  
  $cyear  = $year     if !$cyear;
  
   if ($cmonth != "1") { $lastmo = $cmonth; $lastmo--; }
   if ($cmonth == "1") { $lastmo = "12";     }

   if ($cmonth != "12") { $nmonth = $cmonth; $nmonth++; }
   if ($cmonth == "12") { $nmonth = "1";     }

   $imonth = $cmonth;

   if ($imonth == "1") 
      {
          $pyear = $cyear;
          $pyear--;         
      } else {
                 $pyear = $cyear;
             }


  if ($imonth == "12") 
      {
                $nyear = $cyear;
                $nyear++;         
      } else {
                $nyear = $cyear;
             } 

 $cmonth--;
  
 $html .= qq|
             <table border=0 cellspacing=1 cellpadding=0><tr><td align=left><a href="$template{'mainfile'}?do=calender&month=$lastmo&year=$pyear&day=1">$prevmonth</a></td>\n
             <td colspan=5 align=center><font size=-1><b>$monthnames[$cmonth]</b></font>
             </td><td align=right><a href="$template{'mainfile'}?do=calender&month=$nmonth&year=$nyear&day=1">$nextmonth</a></td></tr>
            |;

    $html .= "<tr><font size=-1>\n";
    foreach ( @dayabbrev ) {
	$html .= "<td align=right width=" . $daywidth . ">"
              .  "<font size=-1>$_</font>"
              .  "</td>\n";
    }
    $html .= "</font></tr>\n";

    my @fifo = ();
    my $skip = &_first_dow($cmonth, $cyear);
    while ( $skip-- ) { push @fifo, "" }
      my $n = &_days_in($cmonth, $cyear);
      foreach ( 1 .. $n ) { push @fifo, $_ }
    while ( @fifo % 7 != 0 ) { push @fifo, "" }
    {
     $html .= "<tr>\n" if @fifo % 7 == 0;

     my $day = shift @fifo;

       $html .= "<td align=right><font size=-1><a href=$template{'mainfile'}?do=calender&goto=viewday&day=" . $day . "&month=$imonth>";
       $html .= $day;
       $html .= "</a></font></td>\n";
       $html .= "</tr>\n" if @fifo % 7 == 0;
  
     last if @fifo == 0;
     redo;
    }

   $html .= "</table>\n";

     $template{'date'}     = "$day_no/$imonth/$year";
     my $sqldate           = "$day_no-$imonth-$year";

	my $statement = qq|SELECT * FROM user_events WHERE user = "$Cookies{'id'}" AND date = "$template{'date'}"|; 
	my $sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	   $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
        	while(my $ref = $sth->fetchrow_hashref()) {   $events .= "$ref->{'subject'}";	}
       $sth->finish;

     $num = 1;

	 $statement = qq|SELECT * FROM calls WHERE time LIKE "%$sqldate%" AND username = "$Cookies{'id'}"|; 
	 $sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	 $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
	while(my $ref = $sth->fetchrow_hashref()) 
    {
      my $img  = "$global{'imgbase'}/mail.gif"   if $ref->{'method'} eq "em";
         $img  = "$global{'imgbase'}/ticket.gif" if $ref->{'method'} ne "em";   
      my $bgcol;
      my $text = '#000000';
    
      if ($num == "2")   
          {
                      $bgcol   =  '#FFFFFF';
                      $num     =   0;
          }
              else {
                      $bgcol   = '#F0F0F0';
                   }
      $number++;
      $listofcalls .= '  <table width="100%" border="0" cellspacing="1" cellpadding="3" align="center"><tr bgcolor="' . "$bgcol" . '"><td height="11" width="6%"><center>' . "<img src=\"$img\">" . '</center></td>
   			        	 <td height="11" width="6%"><font size="1" face="Verdana, Arial, Helvetica, sans-serif" color="' . "$text\"><a href=\"$template{'mainfile'}?do=view&cid=$ref->{'id'}\">$ref->{'id'}" . '</a></font></td>
   				         <td height="11" width="10%"><font size="1" face="Verdana" color="' . "$text\">$ref->{'status'}" . '</font></td>
    			         <td height="11" width="9%"><font size="1" face="Verdana"></font><font size=1 face=Verdana color=' . "$text><div align=center>$ref->{'priority'}</div>" . '</font></td>
    			         <td height="11" width="45%"><a href="' . "$template{'mainfile'}" . '?do=view&cid=' . "$ref->{'id'}\&lang=$language" . '"><font size=1 face=Verdana color=' . "$text>$ref->{'subject'}" . '</a></font></td>
   				         <td height="11" width="24%"><font size=1 face=Verdana color=' . "$text>$ref->{'time'}" . '</font></td></tr></table>';
	  $num++;
    }

	$sth->finish;

    $listofcalls = qq~ <br><div align="center"><font face="Verdana" size="2"><b>No Tickets Logged on $day_no/$imonth/$year</b></div>~ if !$listofcalls;
    $events      = qq~ <br><div align="center"><font face="Verdana" size="2">No Events Scheduled</div>~ if !$events;

   $template{'tickets'}  =  $listofcalls;
   $template{'events'}   =  $events;
   $template{'calender'} =  $html;
   $template{'month'}    =  $month;

      print "Content-type: text/html\n\n";

      my $output = parse("$global{'data'}/include/tpl/calender");
   print $output;
 }


if ($section eq "register2") {

  my  $user  = $q->param('username');
  my  $pass  = $q->param('password');
  my  $pass2 = $q->param('password2');
 
  my  $exists; 	

	my  $sth = $dbh->prepare("SELECT * FROM users WHERE username = ?") or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute($user) or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref())
        {         
            if ($user) {
				if ($ref->{'username'} eq "$user") 
                  {
                      die_nice("$LANG{'username'} <b>$user</b> $LANG{'error2'}");
				                $exists=1;
    			  }
            }
 		} 

        die_nice("$LANG{'username'} <b>$user</b> $LANG{'error2'}") if $user =~ /^unregistered\b/i;

		if (!$exists) 
                {
                       my $error  = "$LANG{'error3'} $LANG{'username'}<br>"       if !$user;
                          $error .= "$LANG{'error3'} $LANG{'password'}<br>"       if !$pass || !$pass2;
                          $error .= "The username cannot contain spaces<br>"         if $user =~ / /;
                          $error .= "$LANG{'username'} <b>$user</b> $LANG{'error2'}" if $user =~ /^unregistered\b/i;
                          $error .= "$LANG{'error4'}"                                if $pass ne $pass2;

                          die_nice("$error") if $error;
                 }

      # Add variables to the template hash

        print "Content-type: text/html\n\n";
  
        $template{'user'}     = $user;
        $template{'password'} = $pass;

        my $output = parse("$global{'data'}/include/tpl/register2");
        print $output;
 
     	$sth->finish;
   }



if ($section eq "register3") {

    print "Content-type: text/html\n\n";

	my $name    = $q->param('name');
	my $email   = $q->param('email');
	my $url     = $q->param('url');
	my $pass    = $q->param('password');
	my $user    = $q->param('username');
	my $company = $q->param('company');
	
    $template{'email'} = $email;

	my  $sth = $dbh->prepare("SELECT * FROM users WHERE username = ?") or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute($user) or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
        {
				if ($ref->{'username'} eq "$user") 
                   {
                      die_nice("Username <b>$user</b> alredy exists<br>");
             	   }
 	    } 
     	$sth->finish;   

        my $error  = "$LANG{'error5'} $LANG{'name'}<br>"              if !$name;
           $error .= "$LANG{'error5'} $LANG{'email'}<br>"             if !$email;
           $error .= "$LANG{'error5'} URL<br>"                        if !$url;
           $error .= "The username cannot contain spaces<br>"         if $user =~ / /;
           $error .= "$LANG{'username'} <b>$user</b> $LANG{'error2'}" if $user =~ /^unregistered\b/i;
           
           die_nice("$error") if $error;

   $template{'user'}     = $user;    
   $template{'username'} = $user;
   $template{'password'} = $pass;
   $template{'cname'}    = $name; 

        my $output = parse("$global{'data'}/include/tpl/register3");
        print $output;
	 
     	my @chars =  (A..Z);
     	my $salt  =  $chars[rand(@chars)] . $chars[rand(@chars)];
  
    	my $password = crypt($pass, $salt);	

        my $validate = $global{'validate'};
        my $reqconf  = $global{'reqvalid'};
 
        my $pending = '0' if $validate eq "0";
           $pending = '1' if $validate eq "1"; 
    
  if ($pending == "1")
   {   
     my $msg = qq|
There is a new user awaiting validation in the administration.

   Username: $user
      Email: $email

Admin: $global{'baseurl'}/admin.cgi
|;
        email( To => $global{'adminemail'}, From => $global{'adminemail'}, Subject => "Pending Support Account", Body => "$msg");
   }

  
   if ($reqconf) 
     {
            my @numbers  = (1..10);
               foreach (1..15) 
                 { 
                    $code .= $numbers[rand(@numbers)];
                 }
      } else {
                $code = 0;
             }

      my $rv = $dbh->do(qq{
                  INSERT INTO users values ("NULL", "$user", "$password", "$name", "$email", "$url", "$company", "$salt", "$pending", "0", "$code", "0")}
         );
 
 if ($reqconf) 
  { 

    	my $id               =  $dbh->{'mysql_insertid'}; 
           $template{'link'} =  qq| $global{'baseurl'}/$template{'mainfile'}?do=activate&key=$code&uid=$id |;      
        my $body;

		open (MAILTPL, "$global{'data'}/include/tpl/activate.txt");
			while (<MAILTPL>) 
                {
                    lang_parse() if $_ =~ /%*%/;
                      s/\{(\S+)\}/$template{$1}/g;
          		      $body .= $_;
			    }  
		close(MAILTPL);	
        email( To => "$email", From => $global{'adminemail'}, Subject => "Activate Account", Body => "$body");
  
  }
   else {

      if ($enablemail) {
         my $body;
  		 open (MAILTPL, "$global{'data'}/include/tpl/welcome.txt");
			while (<MAILTPL>) 
                {
                    lang_parse() if $_ =~ /%*%/;
                       s/\{(\S+)\}/$template{$1}/g;
            	       $body .= $_;
		 	    }  
		 close(MAILTPL);	
         email ( To => "$email", From => "$global{'adminemail'}", Subject => "Help Desk Registration", Body => "$body");
       }
  }  
}


if ($section eq "view")
  {
     check_user();
 
     if (defined $q->param('ticket')) { $trackedcall = $q->param('ticket'); } else { 
         	$trackedcall = $q->param('cid');
       } 

    $template{'trackno'} = $trackedcall;
	$statemente          = 'SELECT * FROM calls WHERE id = ?'; 

	$sth = $dbh->prepare($statemente) or die "Couldn't prepare statement: $DBI::errstr; stopped";
 	$sth->execute( $trackedcall ) or die "Couldn't execute statement: $DBI::errstr; stopped";
		   while(my $ref = $sth->fetchrow_hashref()) {
			if ($ref->{'username'} ne $Cookies{'id'}) 
			{
				$error = 1;
			} else  {
	         			$template{'username'}    = $ref->{'username'};
	        			$template{'email'}       = $ref->{'email'};
	        			$template{'url'}         = $ref->{'url'};
	        			$cuser                   = $ref->{'name'};
	         			$template{'priority'}    = $ref->{'priority'};
	        			$template{'category'}    = $ref->{'category'};
	         			$template{'subject'}     = $ref->{'subject'};
	        			$template{'description'} = $ref->{'description'};
	        			$template{'date'}        = $ref->{'time'};
	        			$template{'status'}      = $ref->{'status'};
                        $active                  = $ref->{'active'}; 
                        $logged                  = $ref->{'track'}; 
	        		}
       }

        if (($sth->rows == 0) || ($error == "1")) {
            die_nice("Request `$trackedcall' does not exist or is not owned by you");
       }

     print "Content-type: text/html\n\n";
     $search_string = $q->param('highlight');

     $statemente = 'SELECT * FROM notes WHERE `call` = ? ORDER BY id;'; 
 	 $sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	 $sth->execute($trackedcall) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	     while(my $ref = $sth->fetchrow_hashref())  {

               $comment = "$ref->{'comment'}";
               $comment = pdcode("$comment");

          if ($ref->{'owner'} eq 0) {
             if ($comment =~ /^</) { } else { $comment =~ s/\n/<br>/g; }
					$notes .= '<table width="100%" border="0" cellspacing="1" cellpadding="3"><tr class="userresponse">' . "<a name=\"$ref->{'id'}\">" . '</a> 
    						   <td width="30%" height="14" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>' . "$ref->{'author'}" . '<br>
    						   </b></font><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "$ref->{'time'}" . '<br><br><a href="' . "$template{'mainfile'}" . '?do=editnote&nid=' . "$ref->{'id'}&lang=$language" . '">MODIFICA</a> </font></td>
    						   <td width="70%" height="14" valign="top"><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "$comment" . '</font></td></tr></table>';
		} elsif ($ref->{'owner'} eq 1) {
				next if $ref->{'visible'} eq 0;
			if ($comment =~ /^</) { } else {
					$comment =~ s/\n/<br>/g;
			}
					   $notes .= '<table width="100%" border="0" cellspacing="1" cellpadding="3"><tr class="userstaffresponse">' . "<a name=\"$ref->{'id'}\">" . '</a>
    						   <td width="30%" height="14" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>' . "$ref->{'author'}" . '<br>
    						   </b></font><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "$ref->{'time'}" . '<br><br></font></td>
    						   <td width="70%" height="14" valign="top"><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "$comment" . '</font></td></tr></table>';
     		}
    	}
    	$dbh->disconnect;
    	if (!$notes) 
         {
     		$notes = '<table width="95%" border="0" cellspacing="0" align="center">
            <tr><td colspan="3"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">No 
            notes added.</font><font size="1" face="Verdana, Arial, Helvetica, sans-serif"></font></td>
            </tr></table>';
    	  } 

     	if ($template{'status'} eq CLOSED) 
         {
             		$template = "viewticket_closed";
     	 } else {
                  	$template = "viewticket";
            	}

      $template{'description'}  =~  s/\n/<br>/g if $template{'description'} !~ /^</;
      $template{'description'}  =   pdcode("$template{'description'}");
      $template{'description'}  =~ s/$search_string/<font color=#FF0000>$search_string<\/font>/ig if $search_string;
         
      $template{'notes'}        =   $notes;

      $current_time = time();

      my $now         =  $current_time;
      my $difference  =  $now - $active;

            if ($difference >= 86400) 
             {
                   $period    =  "day";
                   $count     =  $difference / 86400;
             } elsif ($difference >= 3600) 
               {
                   $period    =  "hour";
                   $count     =  $difference / 3600;
               } elsif ($difference >= 60)  
                  {
                     $period  =  "minute";
                     $count   =  $difference / 60;
                  } else
                     {
                        $period = "second";
                        $count = $difference;
                     }

            $count = sprintf("%.0f", $count);

            if ($count != 1) { $period .= "s"; }

      $template{'ltime'} = $count . ' ' . $period; 



      $tdifference  = $current_time - $logged;

            if ($tdifference >= 86400) 
             {
                   $tperiod   = "day";
                   $tcount    = $tdifference / 86400;
             } elsif ($tdifference >= 3600) 
               {
                   $tperiod   = "hour";
                   $tcount    = $tdifference / 3600;
               } elsif ($tdifference >= 60)  
                  {
                     $tperiod = "minute";
                     $tcount  = $tdifference / 60;
                  } else
                     {
                        $tperiod = "second";
                        $tcount = $difference;
                     }

            $tcount = sprintf("%.0f", $tcount);

            if ($tcount != 1) { $tperiod .= "s"; }

      $template{'ttime'} = $tcount . ' ' . $tperiod; 


      my $output = parse("$global{'data'}/include/tpl/$template");
      print $output;
 }

if ($section eq "print") 
 {

 my $id    = $q->param('cid');
 
 print  qq|
            <table width="90%" border="0" align="center"><tr><td width="48%"><img src="$global{'imgbase'}/logo.gif"></td><td width="52%"><div align="right"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>PRINT 
            REQUEST $id</b></font></div></td></tr><tr><td colspan="2" height="2">
          |;

 die_nice("No Ticket Specified") if !$id;

 $statement = 'SELECT * FROM calls WHERE  id = ?'; 
   $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
   $sth->execute($id) or die print "Couldn't execute statement: $DBI::errstr; stopped";
      $number=0;
          while(my $ref = $sth->fetchrow_hashref()) {	

           if (($ref->{'username'} ne $Cookies{'id'}) || ($ref->{'owner'})) 
             {
                 die_nice("ERROR: You are not authorised to view this call!");
             }			

			$trackno     =  $ref->{'id'};
			$date        =  $ref->{'time'};
			$username    =  $ref->{'username'};
			$priority    =  $ref->{'priority'};
			$status      =  $ref->{'status'};
			$subject     =  $ref->{'subject'};
			$category    =  $ref->{'category'};
			$description =  $ref->{'description'};
			$owner       =  $ref->{'ownership'};
			$number      =  0;
  			$email       =  $ref->{'email'};
			$url         =  $ref->{'url'};
			$name        =  $ref->{'name'};
       }


  $description =~ s/\n/<br>/g;

  print qq|
           <table width="99%" border="0" cellspacing="1" cellpadding="1" align="center"><tr><td colspan="2">&nbsp;</td>
           </tr><tr><td colspan="2"> <div align="right"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">LOGGED: $date BY: $username</font></div>
           </td></tr><tr><td colspan="2">&nbsp;</td></tr><tr valign="middle"><td colspan="2" height="30">&nbsp;</td></tr><tr valign="middle"> 
           <td colspan="2" height="30"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>$subject</b></font></td></tr><tr> 
           <td colspan="2"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">$description</font></td></tr><tr> <td>&nbsp;</td><td>&nbsp;</td>
           </tr><tr><td colspan="2">&nbsp;</td></tr><tr> <td colspan="2"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>ACTIONS/RESPONSES</b></font></td></tr><tr><td colspan="2"><hr>
          |;

	$statemente = 'SELECT * FROM notes WHERE `call` = ? ORDER BY id;'; 
	$sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	$sth->execute($id) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	      while(my $ref = $sth->fetchrow_hashref()) {
				$body = $ref->{'comment'};
	if ($body =~ /^</)  
     {
	       		# Do nothing
	 } else {
	        	$body =~ s/\n/<br>/g;
	        }
	
    if (($ref->{'owner'} eq 0) || ($ref->{'owner'} eq 1))
		{
				print qq|<div align="left"><br><font face="Verdana" size="2"><b>$ref->{'author'}</b> <i>$ref->{'time'}</i><br><font size=1><blockquote>$body</blockquote></font></div><br><hr>| if $ref->{'visible'} == "1";
    	} 

	if ($ref->{'owner'} eq 3) 
		{
		    	print '<table width="100%" border="0" cellspacing="1" cellpadding="2"><tr> 
			   <td width="30%" height="14" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>' . "$ref->{'author'}" . '<br>
			   </b></font><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "$ref->{'time'}" . '<br><br></font></td>
			   <td width="70%" height="14" valign="top"><font face="Verdana, Arial, Helvetica, sans-serif" size="1">' . "<b>STAFF ACTION: $ref->{'action'}</b><br>$body" . '</font></td></tr></table><br><hr>' if $ref->{'visible'} == "1";
    	} 
   }
  
    print qq|</td></tr></table>|;
 
} 

if ($section eq "editnote") {

    check_user();
    print "Content-type: text/html\n\n";

    my $noteid  = $q->param('nid');
       $statemente = 'SELECT * FROM notes WHERE id = ?'; 
       $sth = $dbh->prepare($statemente) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	   $sth->execute($noteid) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	     while(my $ref = $sth->fetchrow_hashref()) 
         {
			if (($ref->{'author'} != $Cookies{'id'}) || ($ref->{'owner'} eq "1")) 
			{
				print 'ERROR: You are not authorised to edit this note!';
                exit;
			}  

       $statement = 'SELECT status FROM calls WHERE id = ?'; 
       $st = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 	   $st->execute($ref->{'call'}) or die print "Couldn't execute statement: $DBI::errstr; stopped";
	     while(my $re = $st->fetchrow_hashref()) 
         {
              $status = $re->{'status'};
         }

        if ($status eq "CLOSED") {

                 	print qq|
				            	<html><p>&nbsp;</p><p>&nbsp;</p><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Sorry</b>, the request associated with this response has been closed, please re-open it before you can edit any notes.</font><br><br>
				            	<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=reopen&id=$ref->{'call'}&lang=$language">click 
				            	here to re-open ticket <b>$ref->{'call'}</b></a></font></p></html>
                            |;
 
           exit;
        }
       		if ($ref->{'author'} == $Cookies{'id'}) 
      	      {	
       			$response= '<table width="100%" border="0"><tr><td><font face="Verdana, Arial, Helvetica, sans-serif" size="2"><b>Modifica 
       						[Call ID: ' . "$ref->{'call'}" . ']</b><BR><BR></font></td></tr><tr><td><form name="form1" method="post" action="' . "$template{'mainfile'}" . '">
    						<table width="100%" border="0"><tr><td width="39%" height="20" valign="top"><font size="2" face="Verdana, Arial, Helvetica, sans-serif">MODIFICA 
      						NOTE</font></td><td width="61%" height="20"><textarea name="comment" class="tbox" cols="55" rows="12">' . "$ref->{'comment'}" . '</textarea>
      						</td></tr><tr><td colspan="2"><div align="center"><input type="hidden" name="ticket" value="' . "$ref->{'call'}" . '"><input type="hidden" name="lang" value="' . "$language" . '"><input type="hidden" name="do" value="save_note"><input type="hidden" name="note" value="' . "$ref->{'id'}" . '">
      						<input type="submit" style="font-size: 12px" name="editnote" value="Submit"></div></td></tr></table></form>';
     		  }
	     }
 
      $template{'response'}  = $response;
   my $output = parse("$global{'data'}/include/tpl/general");
   print $output;
 }

if ($section eq "save_note") {


        check_user();

   my $comment  =  $q->param('comment');
   my $note     =  $q->param('note');
   my $ticket   =  $q->param('ticket');

      $comment  =~ s/</&lt;/g;
      $comment  =~ s/>/&gt;/g;
 
  my $time = time();

     $dbh->do(qq|UPDATE calls SET active = "$time" WHERE id = "$ticket"|);

     my $statement = 'UPDATE notes SET comment = ? WHERE id = ?'; 
     my $sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute( $comment, $note) or die print "Couldn't execute statement: $DBI::errstr; stopped";

        print "Content-type: text/html\n\n";

        my $lang = $q->param('lang');
        
      	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$ticket&lang=$lang"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Response Updated</b>, you are now being taken back to your support request.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$ticket&lang=$lang">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;

 }

if ($section eq "addnote") {


   check_user();

	 $note   = $q->param('note');
	 $ticket = $q->param('ticket');

  my $time = time();

     $dbh->do(qq|UPDATE calls SET active = "$time" WHERE id = "$ticket"|);

	$statement =  qq|UPDATE calls SET aw = "1" WHERE id = "$ticket"|; 
	$sth       =  $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";

     if ($note ne "")  
     {
        $note  =~ s/</&lt;/g;
        $note  =~ s/>/&gt;/g;

      $sth = $dbh->prepare( "INSERT INTO notes VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )" ) or die "couldnt prepare statement";
      $sth->execute( "NULL", "0", "1", "NULL", $ticket, $template{'name'}, $hdtime, $note ) or die "Couldnt execute statement";

        notify_techs( tid => "$ticket", note => "$note", name => "$template{'name'}", time => "$hdtime" );
     }

        print "Content-type: text/html\n\n";
 
        my $lang = $q->param('lang');

     	print qq|
					<html><p>&nbsp;</p><p>&nbsp;</p><meta http-equiv="refresh" content="1;URL=$template{'mainfile'}?do=view&cid=$ticket&lang=$lang"><p align="center"><font size="2" face="Verdana, Arial, Helvetica, sans-serif"><b>Response Added</b>, you are now being taken back to your support request.</font><br><br>
					<font size="1" face="Verdana, Arial, Helvetica, sans-serif"><a href="$template{'mainfile'}?do=view&cid=$ticket&lang=$lang">click 
					here</a> if you are not automatically forwarded</font></p></html>
                |;
  }
}

sub _first_dow 
  {

    my($month, $year) = @_;	# $month in (0..11), $year as YYYY

    if ( $month < 2 ) 
     {
        $month += 12;
        --$year;
     }

     my $z1 = (26 * ($month + 2)) / 10;
     my $z2 = int((125 * $year) / 100);
     return ($z1 + $z2 - int($year / 100) + int($year / 400)) % 7;
  }

sub _days_in 
  {
    my($month, $year) = @_;     # $month in (0..11), $year is YYYY

    return 29 if $month == 1 && ($year % 4) == 0;
    (31,28,31,30,31,30,31,31,30,31,30,31)[$month];
  }

1;
