#!/usr/bin/perl
use CGI qw(:standard);
use CGI::Carp 'fatalsToBrowser';
$CGI::POST_MAX = 5 * 1024 * 1024;  # Fissato a 5Mb

##############################################################################
#                                                                            #
# BFormMail                        Version 2.0                               #
#                                                                            #
# Copyright 1997-2001 Brian Sietz  bsietz@infosheet.com                      #
# The Byte Shop - Small Business Solutions for Internet Web Development      #
# http://www.infosheet.com                                                   #
# Created:  8/14/1997                                                        #
# Modified: 12/17/2001                                                       #
#                                                                            #
# Modifications Copyright (c) 1997-2001 Brian S. Sietz, All Rights Reserved. #
# This version of FormMail may be used and modified free of charge by anyone #
# so long as this copyright notice and the one below by Matthew Wright remain#
# intact. By using this code you agree to indemnify Brian Sietz from any     #
# liability arising from it's use. You also agree that this code cannot be   #
# sold to any third party without prior written consent of both Brian Sietz  #
# and Matthew M. Wright.                                                     #
#                                                                            #
##############################################################################
# FormMail                        Version 1.9                                #
# Copyright 1995-2001 Matt Wright mattw@worldwidemart.com                    #
# Created 06/09/95                Last Modified 08/03/01                     #
# Matt's Script Archive, Inc.:    http://www.worldwidemart.com/scripts/      #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1995-2001 Matthew M. Wright  All Rights Reserved.                #
#                                                                            #
# FormMail may be used and modified free of charge by anyone so long as this #
# copyright notice and the comments above remain intact.  By using this      #
# code you agree to indemnify Matthew M. Wright from any liability that      #
# might arise from its use.                                                  #
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.  In all cases copyright and header must remain intact #
##############################################################################
# ACCESS CONTROL FIX: Peter D. Thompson Yezek                                #
#                     http://www.securityfocus.com/archive/1/62033           #
##############################################################################
#                                                                            #
#                                                                            #
# BFormMail                                                                  #
#                                                                            #
#      Took Matt's original 1.6 script and made some mods...                 #
#      Then took Matt's 1.9 and added the security features here             #
#                                                                            #
#      Mods made were mostly from features in yForm                          #
#      which was Matt's original FormMail 1.5 with changes by:               #
#      Donald E. Killen 10/2/96 and                                          #
#      Ashley Bass 1/29/97                                                   #
#                                                                            #
# History:                                                                   #
#                                                                            #
#   Added 6/29/97:                                                           #
#      - Added table output to HTML (orig by Don Killen in yForm)            #
#      - Added printing of realname & email in HTML output (orig Ashley Bass)#
#      - Added misc form fields:                                             #
#          cc  - if present, a Cc: is added to the e-mail when sent          #
#          bcc - if present, a Bcc: is added to the e-mail when sent         #
#      - Added courtesy reply (based on code from yForm)                     #
#        Changed field names; a bit longer, but easier to understand:        #
#          courtesy_reply - if present and email also present, reply sent    #
#          courtesy_reply_texta, First line of courtesy reply text           #
#          courtesy_reply_textb, Second line of courtesy reply text          #
#          courtesy_who_we_are, Name or company underneath the "Regards"     #
#          courtesy_our_url, URL to print after "Regards"                    #
#          courtesy_our_email, e-mail to print after "Regards"               #
#      - Added database option (based on code from yForm)                    #
#          append_db, if present, value is the data file to append to        #
#          db_delimiter, delimiter between fields                            #
#      - Removed FormMail display in HTML output (except error output)       #
#          Nobody should care about who wrote the script, if they really     #
#          want to know, they should send e-mail to the webmaster...         #
#                                                                            #
#   Added 8/14/97:                                                           #
#      - Added support for e-mail to fax services by adding two form fields: #
#          faxto, if specified is the e-mail address of the fax service.     #
#                 for Faxaway, it would be a phone number@faxaway.com, i.e.  #
#                 16097951994@faxaway.com                                    #
#          faxfrom, specifies the From: field for the fax.  Faxaway requires #
#                 field to be a valid Faxaway customer.                      #
#        More information can be found in the BFormMail.readme file or       #
#        at http://www/faxaway.com                                           #
#      - Added db_fields config field to control which fields are appended   #
#        to the database.                                                    #
#      - All form fields appended to database are stripped of newlines so    #
#        that all outputted fields will be on a single record                #
#                                                                            #
#   Added 1/27/98:                                                           #
#      - Added courtesy_who_we_are2 - same as courtesy_who_we_are but an     #
#        extra line of text if needed.                                       #
#      - Added support for another e-mail to fax service.  Fax service is    #
#        selected by the faxservice field.  Currently, the faxservice field  #
#        can specify 'faxaway' or 'faxsav' or 'netmoves'. Each service       #
#        requires a slightly (faxsav & netmoves are the same)                #
#        different header. The following fields fully control the form-fax   #
#        gateway:                                                            #
#          faxservice, if specified enables the form-to-fax gateway and will #
#             specify the desired service.  The current services supported   #
#             are 'faxsav', 'netmoves' and 'faxaway'.                        #
#             For more information on these                                  #
#             services visit http://www.netmoves.com or                      #
#             http://www.faxaway.com                                         #
#             Please note, faxsav  requires the variable $faxstamp           #
#             to be set - see below.                                         #
#          faxnum, specifies the telephone number to send the fax.  For      #
#             security, the full e-mail address is assembled in the script.  #
#             Both faxsav & faxaway require the format as follows:           #
#             16095551212                                                    #
#          faxfrom, specifies the From: field for the fax.  Must be from an  #
#             authorized account from both services.   For example:          #
#             bsietz@infosheet.com                                           #
#        More information can be found in the BFormMail.readme file.         #
#                                                                            #
#   Added 7/16/98:                                                           #
#      - Added check for valid e-mail address, if specified for cc: & bcc:   #
#                                                                            #
#   Added 12/9/98:                                                           #
#      - Fixed bug in print_blank_fields                                     #
#                                                                            #
#   Added 8/15/99:                                                           #
#      - Y2K fix provided by Karl Bogott                                     #
#                                                                            #
#   Added 10/10/99:                                                          #
#      - In routine check_url, if HTTP_REFERER not available, no longer      #
#        return true.                                                        #
#                                                                            #
#   Added 3/12/2000:                                                         #
#      - Fixed ?? bug in redirect tag                                        #
#                                                                            #
#   Added 4/18/2000:                                                         #
#      - Added cc_visitor tag - send copy of form results to visitor         #
#                                                                            #
#   Added 1/22/2001:                                                         #
#      - Modified fax to support netmoves (formerly faxsav)                  #
#                                                                            #
#   Added 9/16/2001:                                                         #
#      - Added EasyLink to list of fax services (formerly netmoves or faxsav #
#                                                                            #
#   Added 12/2001:                                                           #
#      - Added security fixes from FormMail Version 1.9                      #
#                                                                            #
##############################################################################


# Define Variables                                                           #
#        Detailed Information Found In README File.                            #

# $mailprog defines the location of your sendmail program on your unix       #
# system.                                                                    #

$mailprog = '/usr/sbin/sendmail';
$use_log = 0;   # setta a 1 per l'uso del file di log.
$logfile = "/var/www/vhosts/neikos.it/subdomains/dbmail/logs";

# @referers allows forms to be located only on servers which are defined     #
# in this field.  This security fix from the last version which allowed      #
# anyone on any server to use your FormMail script on their web site.        #

@referers = ('www.nomedominiocheabusa.it','www.cariocaclub.it','62.149.130.44','www.liberoweb.net','it.geocities.com','main.2mat.info','www.agricolaforesta.it','agricolaforesta.it', 'www.centrorisorse.org', 'centrorisorse.org', '74.53.93.108');

# @recipients defines the e-mail addresses or domain names that e-mail can   #
# be sent to.  This must be filled in correctly to prevent SPAM and allow    #
# valid addresses to receive e-mail.  Read the documentation to find out how #
# this variable works!!!  It is EXTREMELY IMPORTANT.                         #

@recipients = @referers;


# ACCESS CONTROL FIX: Peter D. Thompson Yezek                                #
# @valid_ENV allows the sysadmin to define what environment variables can    #
# be reported via the env_report directive.  This was implemented to fix     #
# the problem reported at http://www.securityfocus.com/bid/1187              #

@valid_ENV = ('REMOTE_HOST','REMOTE_ADDR','REMOTE_USER','HTTP_USER_AGENT');

# BSS
# The EasyLink service requires a special stamp as part of the e-mail header #
# for additional security.  This stamp, along with the appropriate 'from'    #
# field are required in order to send a fax.                                 #
#                                                                            #
# Replace passwd in the line below with the stamp issued from EasyLink.      #
# visit http://www.EasyLink.com for more information.                        #

$faxstamp = 'passwd';

# Done                                                                       #
##############################################################################


# by Ago
###########################################################
# Dati del database utilizzato per archiviare i dati.     #
###########################################################
use DBI();
$dbhost = 'localhost';          # host.
$dbname = 'neikos_dbmail';      # nome del database.
$dbuser = 'dbmail';             # nome utente.
$dbpass = 'dbm632';             # password.
$dbnamenews = 'neikos_dbnews';  # nome del database della newsletter.
$dbusernews = 'dbnews';         # nome utente della newsletter.
$dbpassnews = 'dbm632';         # password della newsletter.

$emailam = "staff\@neikos.it"; # e-mail dell'ammini-
                                   # stratore del sistema.
###########################################################

# Retrieve Date
&get_date;

# Check Referring URL
&check_url;

# Parse Form Contents
&parse_form;

# Check Required Fields
&check_required;

if  ($Config{'table'} ne "") {
        #Append Database
        $s = false;
        $s = &append_database;

        #mod rob o c'e' table o non manda niente
        #cat /home/mail.neikos.it/mail/logs/access | grep "POST /cgi-bin/dbmail.pl"

        if ($s ne "false") {
                # Send E-Mail
                &send_mail;

                #BSS
                # Courtesy E-Mail to Visitor
                &send_courtesy;

                # Send E-Fax
                if ($Config{'faxservice'}) {
                        &send_mail($Config{'faxservice'})
                };

                # Return HTML Page or Redirect User
                &return_html;
        } else {
                &error('bad_referer');
        }
} else {
        &error('bad_referer');
}

#BSS

# Main ends here - only subroutines follow                                   #
##############################################################################

sub check_url {

    # Localize the check_referer flag which determines if user is valid.     #
    local($check_referer) = 1;

    # If a referring URL was specified, for each valid referer, make sure    #
    # that a valid referring URL was passed to FormMail.                     #

    if ($ENV{'HTTP_REFERER'}) {
        foreach $referer (@referers) {
            if ($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$referer|i) {
                    $check_referer = 0;
                last;
            }
        }
    }
    else {
        $check_referer = 1;
    }

    # If the HTTP_REFERER was invalid, send back an error.                   #
    if ($check_referer != 1) { &error('bad_referer') }
}

sub get_date {

    # Define arrays for the day of the week and month of the year.           #
    @days   = ('Domenica','Luned','Marted','Mercoled',
               'Gioved','Venerd','Sabato');
    @months = ('Gen','Feb','Mar','Apr','Mag','Giu','Lug',
                 'Ago','Set','Ott','Nov','Dic');

    # Get the current time and format the hour, minutes and seconds.  Add    #
    # 1900 to the year to get the full 4 digit year.                         #
    ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
    $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);

    # $year += 1900;
    # Y2K fix provided by Karl Bogott 8/1999
    if ($year < 50){
                $year += 2000;
    } else {
                $year += 1900;
    }

    # Format the date.                                                       #
    # $date = "$days[$wday], $months[$mon] $mday, $year alle ore $time";
    $date = "$mday $months[$mon] $year alle ore $time";
    $date1 = "$mday $months[$mon] $year at $time";
    $date_fra = "$mday $months[$mon] $year  $time heures";
    $mon2 = $mon + 1;
    $date2 = "$mday/$mon2/$year";
# by Ago
    $date3 = "$year-$mon2-$mday";
    if ($mon2<10) {
        $zero = "0";
    }   else {
        $zero   = "";
    }
    $datentmk = "$zero$mon2-$year";
}

sub parse_form {

    # Define the configuration associative array. #
    %Config = ('recipient','',          'subject','',
               'email','',              'realname','',
               'redirect','',           'bgcolor','',
               'background','',         'link_color','',
               'vlink_color','',        'text_color','',
               'alink_color','',        'title','',
               'sort','',               'print_config','',
               'required','',           'env_report','',
               'return_link_title','',  'return_link_url','',
               'print_blank_fields','', 'missing_fields_redirect','',
#BSS
             'cc','',                   'bcc','',
               'courtesy_reply','',
               'courtesy_our_url','',   'courtesy_our_email','',
               'courtesy_reply_texta','',
               'courtesy_reply_textb','',
                   'courtesy_reply_saluto','',
               'courtesy_who_we_are','','courtesy_who_we_are2','',
                   'courtesy_subject_in_email', '',
               'append_db','',          'db_delimiter','',
               'db_fields','',
               'faxservice','',
               'faxnum','',              'faxfrom','',
               'cc_visitor','',
               'lang','',
#BSS
# by Ago
             'table','',                'recipientdomain','',
                 'dbb_fields_normal','',        'dbb_fields_big','',
                 'firstname','',                'email_type','',
                 'file', '',            'if', '',
                 'dbb_fields_file', '', 'estensioni_file', ''
#

           );


    # Definisce i campi che interessano il database generale.
    %CampiM = ('email','',              'realname','',
               'lang','',                   'firstname',''
    );


    if ($ENV{'CONTENT_TYPE'} =~ "multipart/form-data") {
                # by Ago - Sostituisce i metodi di lettura delle
                #          variabili.
                $cgi = new CGI;

                $p = "";
                foreach my $name ($cgi->param) {
                        $p .= $name;
                        push @pairs, $name ."=". $cgi->param($name);
                }

                if ($p eq "") {
                        &error('missing_fields');
                }
    } else {
                # Determine the form's REQUEST_METHOD (GET or POST) and split the form   #
                # fields up into their name-value pairs.  If the REQUEST_METHOD was      #
                # not GET or POST, send an error.                                        #
                if ($ENV{'REQUEST_METHOD'} eq 'GET') {
                        # Split the name-value pairs
                        @pairs = split(/&/, $ENV{'QUERY_STRING'});
                } elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
                        # Get the input
                        read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

                        # Split the name-value pairs
                        @pairs = split(/&/, $buffer);
                } else {
                        &error('request_method');
                }
    }


        ## log ####################################################
        if ($use_log eq "1") {
                open(LOG, ">>$logfile");
                print LOG "$date2 $time - Inizio email $p\n";
        }
        ###########################################################

    # For each name-value pair:                                              #
    foreach $pair (@pairs) {
        # Split the pair up into individual variables.                       #
        local($name, $value) = split(/=/, $pair, 2);

        # Decode the form encoding on the name and value variables.          #
        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

        # If they try to include server side includes, erase them, so they
        # aren't a security risk if the html gets returned.  Another
        # security hole plugged up.
        $value =~ s/<!--(.|\n)*-->//g;

                # Controlla che nn ci siano tag HTML nei
                # campi prima dell'invio della courtesy_email
                # che potrebbe essere usata per fare spam.
                if (exists $Config{$name}) {
                        # Si tratta di un parametro di configurazione...
                } else {
                        if (($value =~ /<(?:[^>'"]*|(['"]).*?\1)*>/) || ($value =~ /http(s)?:\/\//)) {
                                &error('html_tag');
                        }
                }

                ## log ####################################################
                if ($use_log eq "1") {
                        print LOG "\t$name -> $value\n";
                }
                ###########################################################

        # If the field name has been specified in the %Config array, it will #
        # return a 1 for defined($Config{$name}}) and we should associate    #
        # this value with the appropriate configuration variable.  If this   #
        # is not a configuration form field, put it into the associative     #
        # array %Form, appending the value with a ', ' if there is already a #
        # value present.  We also save the order of the form fields in the   #
        # @Field_Order array so we can use this order for the generic sort.  #
        if (defined($Config{$name})) {
            $Config{$name} = $value;
        } else {
            if ($Form{$name} && $value) {
                $Form{$name} = "$Form{$name}, $value";
            } else {
                push(@Field_Order, $name);
                $Form{$name} = $value;
            }
        }
    }

        # Controlla che l'email (se presente) sia valida:
        if (($Config{'email'} ne "") && !&check_email($Config{'email'})) {
                &error('missing_fields', 'email');
        }

        ## log ####################################################
        if ($use_log eq "1") {
                print LOG "\tREMOTE_HOST -> ".$ENV{'REMOTE_HOST'}."\n";
                print LOG "\tHTTP_USER_AGENT -> ".$ENV{'HTTP_USER_AGENT'}."\n";
                print LOG "\tREMOTE_ADDR -> ".$ENV{'REMOTE_ADDR'}."\n";
                print LOG "\tHTTP_REFERER -> ".$ENV{'HTTP_REFERER'}."\n";
                print LOG "Fine email\n\n";
                close(LOG);
        }
        ###########################################################


    # The next six lines remove any extra spaces or new lines from the       #
    # configuration variables, which may have been caused if your editor     #
    # wraps lines after a certain length or if you used spaces between field #
    # names or environment variables.                                        #
    $Config{'required'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'required'} =~ s/(\s+)?\n+(\s+)?//g;
    $Config{'env_report'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'env_report'} =~ s/(\s+)?\n+(\s+)?//g;
    $Config{'print_config'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'print_config'} =~ s/(\s+)?\n+(\s+)?//g;
    $Config{'db_fields'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'db_fields'} =~ s/(\s+)?\n+(\s+)?//g;

# modifica by ago2 #
    $Config{'dbb_fields_big'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'dbb_fields_big'} =~ s/(\s+)?\n+(\s+)?//g;
    $Config{'dbb_fields_normal'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'dbb_fields_normal'} =~ s/(\s+)?\n+(\s+)?//g;
    $Config{'dbb_fields_file'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
    $Config{'dbb_fields_file'} =~ s/(\s+)?\n+(\s+)?//g;
###################

    # Split the configuration variables into individual field names.         #
    @Required = split(/,/,$Config{'required'});
    @Env_Report = split(/,/,$Config{'env_report'});
    @Print_Config = split(/,/,$Config{'print_config'});
    @Print_DB = split(/,/,"$Config{'db_fields'},$Form{'db_fields'}");

# modifica by ago2 #
    @Print_DBB_normal = split(/,/,"$Config{'dbb_fields_normal'},$Form{'dbb_fields_normal'}");
    @Print_DBB_big = split(/,/,"$Config{'dbb_fields_big'},$Form{'dbb_fields_big'}");
    @Print_DBB_file = split(/,/,"$Config{'dbb_fields_file'},$Form{'dbb_fields_file'}");
    @Print_DBB = split(/,/,"$Config{'dbb_fields_big'},$Form{'dbb_fields_big'}");
    unshift @Print_DBB, split(/,/,"$Config{'dbb_fields_normal'},$Form{'dbb_fields_normal'},$Config{'dbb_fields_file'},$Form{'dbb_fields_file'}");
    # unshift @Print_DBB, split(/,/,"$Config{'dbb_fields_file'},$Form{'dbb_fields_file'}");
###################

    # ACCESS CONTROL FIX: Only allow ENV variables in @valid_ENV in          #
    # @Env_Report for security reasons.                                      #
    foreach $env_item (@Env_Report) {
        foreach $valid_item (@valid_ENV) {
            if ( $env_item eq $valid_item ) { push(@temp_array, $env_item) }
        }
    }
    @Env_Report = @temp_array;

}

sub check_required {
    # Localize the variables used in this subroutine.                        #
    local($require, $recipient2, @error );

    $recipient2 = $Config{'recipient'};

    # modifica by Ago #
    if ((($Config{'recipient'} =~ /@/) == false) && ($Config{'recipientdomain'} ne "")) {
                (@emails) = split(/,/,$Config{'recipient'});
                (@domains) = split(/,/,$Config{'recipientdomain'});

                for ($a=0;$a<=$#emails;$a++) {
                        print LOG "\n\n" . $a . ". " . $domains[$a];

                        if ($domains[$a] eq "") {
                                $domains[$a] = $domains[0];
                        }

                        # Elimina gli spazi bianchi
                        $emails[$a] =~ s/\s//g;
                        $domains[$a] =~ s/\s//g;

                        $dest[$a] = $emails[$a] . "@" . $domains[$a];
                }

                $recipient2 = join(',',@dest);
    }

    # if (($recipient2 ne "") && (($recipient2 =~ /@/) == false) && ($Config{'recipientdomain'} ne "")) {
    #   $recipient2 = $recipient2 . '@' . $Config{'recipientdomain'};
    # }
    ###################


        # FormMail & BFormMail allows for a recipient email address in the form:
        # "bsietz@infosheet.com (Brian Sietz)" so that any email received by sendmail
        # would have in the header:    To: Brian Sietz (bsietz@infosheet.com).
        # Until Matt Wright added his security enhancements in FormMail v1.9, this
        # worked ok, however the recipient check below would fail with the added
        # name in parenthesis.  The following two lines below remove any spaces at
        # the beginning of the string, and delete all characters following a space
        # if it exists.  The recipient is then check against the valid recipients.
        # The original recipient string remains unchanged for use in the email routines

    $recipient2 =~ s/^\s+|\s+$//g;
    $recipient2 =~ s/\s.*//;

    if ($Config{'subject'} =~ /(\n|\r)/m ||
        $recipient2 =~ /(\n|\r)/m) {
        &error('no_recipient');
    }

    if (!$recipient2) {
        if (!defined(%Form)) { &error('bad_referer') }
        else                 { &error('no_recipient') }
    } else {
        # This block of code requires that the recipient address end with    #
        # a valid domain or e-mail address as defined in @recipients.        #
        $valid_recipient = 0;

        foreach $send_to (split(/,/,$recipient2)) {
                        $valido = "true";
            foreach $recipient (@recipients) {
                # if ($send_to =~ /$recipient$/i) {
                #    push(@send_to,$send_to); last;
                # }

                        if ($send_to =~ /$recipient$/i) {
                                        $valido = "false";
                                        last;
                        }
            }

                        if ($valido eq "true") {
                                push(@send_to,$send_to);
                        }
        }

        if ($#send_to < 0) { &error('no_recipient') }
        $recipient2 = join(',',@send_to);
    }

    # For each require field defined in the form:                            #
    foreach $require (@Required) {
        # If the required field is the email field, the syntax of the email  #
        # address if checked to make sure it passes a valid syntax.          #

                if ($require eq 'email' && !&check_email($Config{$require})) {
            push(@error,$require);
        }

        # Otherwise, if the required field is a configuration field and it   #
        # has no value or has been filled in with a space, send an error.    #
        elsif (defined($Config{$require})) {
            if (!$Config{$require}) {
                push(@error,$require);
            }
        }

        # If it is a regular form field which has not been filled in or      #
        # filled in with a space, flag it as an error field.                 #
        elsif (!$Form{$require}) {
            push(@error,$require);
        }
    }

    # If any error fields have been found, send error message to the user.   #
    if (@error) { &error('missing_fields', @error) }
}

sub return_html {
    # Local variables used in this subroutine initialized.                   #
    local($key,$sort_order,$sorted_field);

    # If redirect option is used, print the redirectional location header.   #
    if ($Config{'redirect'}) {
        print "Location: $Config{'redirect'}\n\n";
    }

    # Otherwise, begin printing the response page.                           #
    else {

        # Print HTTP header and opening HTML tags.                           #
        print "Content-type: text/html; charset=UTF-8\n\n";
        print "<html>\n <head>\n";

        # Print out title of page                                            #
        if ($Config{'title'}) { print "  <title>$Config{'title'}</title>\n" }
        else                  { print "  <title>Grazie!</title>\n"        }

        print " </head>\n <body";

        # Get Body Tag Attributes                                            #
        &body_attributes;

        # Close Body Tag                                                     #
        print ">\n  <center>\n";

        # Print custom or generic title.                                     #
        if ($Config{'title'}) { print "   <h1>$Config{'title'}</h1>\n" }
        else { print "   <h1>Grazie per aver compilato il nostro Form!</h1>\n" }

        print "</center>\n";

        # modifica by Ago #
        $destinatario = &destinatario_email();
            ###################

        print "Risultato compilazione modulo $destinatario: ";
        print "<br>on $date<p><hr size=1 width=75\%><p>\n";

        #BSS Table output for HTML (orig Don Killen)
        #    Also realname and email fields (orig Ashley Bass)
        print "<table cellspacing=2 cellpadding=1>";
                if ($Config{'realname'}) {
            print "<tr><td align=right><b>Nome:</b></td>";
                        print "<td align=left>$Config{'realname'}</td></tr>\n"
        }

        if ($Config{'email'}) {
            print "<tr><td align=right><b>E-mail:</b></td>";
                        print "<td align=left>$Config{'email'}</td></tr>\n\n"
        }
        #BSS

        # Sort alphabetically if specified:                                  #
        if ($Config{'sort'} eq 'alphabetic') {
            foreach $field (sort keys %Form) {

                # If the field has a value or the print blank fields option  #
                # is turned on, print out the form field and value.          #
                if ($Config{'print_blank_fields'} || $Form{$field}) {
                    #BSS - table output
                    #print "<b>$field:</b> $Form{$field}<p>\n";
                    print "<tr><td align=right>$field:</td>";
                    print "<td align=left>$Form{$field}</td></tr>\n";
                    #BSS
                }
            }
        }

        # If a sort order is specified, sort the form fields based on that.  #
        elsif ($Config{'sort'} =~ /^order:.*,.*/) {

            # Set the temporary $sort_order variable to the sorting order,   #
            # remove extraneous line breaks and spaces, remove the order:    #
            # directive and split the sort fields into an array.             #
            $sort_order = $Config{'sort'};
            $sort_order =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
            $sort_order =~ s/(\s+)?\n+(\s+)?//g;
            $sort_order =~ s/order://;
            @sorted_fields = split(/,/, $sort_order);

            # For each sorted field, if it has a value or the print blank    #
            # fields option is turned on print the form field and value.     #
            foreach $sorted_field (@sorted_fields) {
                if ($Config{'print_blank_fields'} || $Form{$sorted_field}) {
                    #BSS - table output
                    #print "<b>$sorted_field:</b> $Form{$sorted_field}<p>\n";
                    print "<tr><td align=right>$sorted_field:</td>";
                    print "<td align=left>$Form{$sorted_field}</td></tr>\n";
                    #BSS
                }
            }
        }

        # Otherwise, default to the order in which the fields were sent.     #
        else {

            # For each form field, if it has a value or the print blank      #
            # fields option is turned on print the form field and value.     #
            foreach $field (@Field_Order) {
                if ($Config{'print_blank_fields'} || $Form{$field}) {
                    #BSS - table output
                    #print "<b>$field:</b> $Form{$field}<p>\n";
                    print "<tr><td align=right><b>$field:</b></td>";
                    print "<td align=left>$Form{$field}</td></tr>\n";
                    #BSS
                }
            }
        }

#BSS
        print "</table><br clear=all>\n";
#BSS


        print "<p><hr size=1 width=75%><p>\n";

        # Check for a Return Link and print one if found.                    #
        if ($Config{'return_link_url'} && $Config{'return_link_title'}) {
            print "<ul>\n";
            print "<li><a href=\"$Config{'return_link_url'}\">$Config{'return_link_title'}</a>\n";
            print "</ul>\n";
        }

        # Print the page footer.                                             #
        print <<"(END HTML FOOTER)";
        <hr size=1 width=75%><p>
        </body>
       </html>
(END HTML FOOTER)
    }
}

sub send_mail {
    # Localize variables used in this subroutine.                            #

#BSS
    local ($faxservice) = @_;

    local($print_config,$key,$sort_order,$sorted_field,$env_report);

        # Destinatario dell'email:
        $destinatario = &destinatario_email();

        # Prende i destinatari:
        @destinatari = split(/,/, $destinatario);
        $primoDestinatario = $destinatari[0];

    # Open The Mail Program
    open(MAIL,"|$mailprog -f $primoDestinatario -t");

    if ($faxservice)  {
                # Fax disabilitato by Ago
                # if ($faxservice eq 'faxaway') {
        #       print MAIL "To: $Config{'faxnum'}\@faxaway.com\n";
                #       print MAIL "From: $Config{'faxfrom'}\n";
        # }
                # if ( ($faxservice eq 'faxsav') ||
                #     ($faxservice eq 'netmoves') ||
                #     ($faxservice eq 'easylink') ) {
                # print MAIL "To: $Config{'faxnum'}\@faxmail.com\n";
                # print MAIL "X-STAMP: $faxstamp\n";
                # print MAIL "X-FAXSENDER: $Config{'faxfrom'}\n";
        # }
    } else {
                print MAIL "To: $destinatario\n";
        print MAIL "From: $Config{'email'} ($Config{'realname'} $Config{'firstname'})\n";

                # Copia a mailin@rvt.net
        print MAIL "Bcc: mailin\@rvt.net\n";

                if ($Config{'cc'} && check_email($Config{'cc'})) {
                        print MAIL "Cc: $Config{'cc'}\n";
                }
                if ($Config{'cc_visitor'}) {
                        print MAIL "Cc: $Config{'email'} ($Config{'realname'})\n";
                }
        if ($Config{'bcc'} && check_email($Config{'bcc'})) {
                        print MAIL "Bcc: $Config{'bcc'}\n";
                }
    }
#BSS

    # Check for Message Subject
    if ($Config{'subject'}) {
                print MAIL "Subject: $Config{'subject'}\n"
    } else {
                if (($Config{'lang'}) eq 'eng') {
                        print MAIL "Subject: Neikos - Contact form \n"
                } else {
                        print MAIL "Subject: Neikos - Modulo contatto \n"
                }
    }

    if (scalar(@Print_DBB_file)>0) {
                ###### Allegati all'email - by Ago ######
                $IID = (scalar time);
        $boundary="Message-Boundary-".$IID;

        print MAIL "MIME-Version: 1.0\n";
                print MAIL "Content-Type: multipart/mixed;\n";
                print MAIL "\tboundary=$boundary\n";
                print MAIL "\n";
                print MAIL "\n";
        print MAIL "--$boundary\n";

                foreach $campo (@Print_DBB_file) {
                        # Inizializza le variabili.
                        undef $data;
                        undef $filename;
                        $size = 0;

                        $file = $cgi->param($campo);
                        sysseek($file, 0, SEEK_CUR);
                while ($bytes_count = sysread($file,$buff,1024)) {
                        $data .= $buff;
                                $size += $bytes_count;  # grandezza del file in byte.
                }

                        if ($size > 0) {
                                # Il nome del file.
                                $file =~ /([^\/\\]+)$/;
                                $filename = $1;
                                $filename =~ s/^\.+//;

                                (@parti) = split(/\./,$filename);
                                $estf = $parti[scalar(@parti)-1];  # Estensione del file.

                                ## Scrive l'header dell'allegato.
                                print MAIL "Content-type: application/octet-stream; name=\"$filename\"; type=Unknown\n";
                                print MAIL "Content-transfer-encoding: BASE64\n";
                                print MAIL "Content-disposition: attachment\n";

                                print MAIL "\n";

                                $data = encode_base64($data); # Utilizza il base64

                                # Allega il file
                                print MAIL $data;
                                print MAIL "\n\n";
                                print MAIL "--$boundary\n";
                        }
                }
    }

        print MAIL "Content-Type: text/plain; charset=UTF-8\n";
    print MAIL "\n";

        if (($Config{'lang'}) eq 'eng') {
                print MAIL "$Config{'subject'} - Contact form :\n";
                print MAIL "Compiled by: $Config{'realname'} $Config{'firstname'} ($Config{'email'})\n    on $date1\n";
        } else {
                print MAIL "$Config{'subject'} - Modulo contatto :\n";
                print MAIL "Compilato da: $Config{'realname'} $Config{'firstname'} ($Config{'email'})\n    il $date\n";
        }

#BSS
    # if ($Config{'faxservice'}) {
    # print MAIL "Feedback results were also faxed to: $Config{'faxnum'}\n";
    # }
#BSS

    print MAIL "-" x 75 . "\n\n";

        if (($Config{'lang'}) eq 'eng') {
                print MAIL "Sender: $Config{'realname'} $Config{'firstname'}\n";
        } else {
                print MAIL "Mittente: $Config{'realname'} $Config{'firstname'}\n";
        }

    print MAIL "E-mail: $Config{'email'}\n\n";

    if (@Print_Config) {
        foreach $print_config (@Print_Config) {
            if ($Config{$print_config}) {
                print MAIL "$print_config: $Config{$print_config}\n\n";
            }
        }
    }

    # Sort alphabetically if specified:                                      #
    if ($Config{'sort'} eq 'alphabetic') {
        foreach $field (sort keys %Form) {

            # If the field has a value or the print blank fields option      #
            # is turned on, print out the form field and value.              #
            if ($Config{'print_blank_fields'} || $Form{$field} ||
                $Form{$field} eq '0') {
                print MAIL "$field: $Form{$field}\n\n";
            }
        }
    }

    # If a sort order is specified, sort the form fields based on that.      #
    elsif ($Config{'sort'} =~ /^order:.*,.*/) {

        # Remove extraneous line breaks and spaces, remove the order:        #
        # directive and split the sort fields into an array.                 #
        $Config{'sort'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
        $Config{'sort'} =~ s/(\s+)?\n+(\s+)?//g;
        $Config{'sort'} =~ s/order://;
        @sorted_fields = split(/,/, $Config{'sort'});

        # For each sorted field, if it has a value or the print blank        #
        # fields option is turned on print the form field and value.         #


        foreach $sorted_field (@sorted_fields) {
            if ($Config{'print_blank_fields'} || $Form{$sorted_field} ||
                $Form{$sorted_field} eq '0') {
                print MAIL "$sorted_field: $Form{$sorted_field}\n\n";
            }
        }
    }

    # Otherwise, default to the order in which the fields were sent.         #
    else {

        # For each form field, if it has a value or the print blank          #
        # fields option is turned on print the form field and value.         #
        foreach $field (@Field_Order) {
            if ($Config{'print_blank_fields'} || $Form{$field} ||
                $Form{$field} eq '0') {
                print MAIL "$field: $Form{$field}\n\n";
            }
        }
    }

    print MAIL "-" x 75 . "\n\n";

    # Send any specified Environment Variables to recipient.                 #
    foreach $env_report (@Env_Report) {
        if ($ENV{$env_report}) {
            print MAIL "$env_report: $ENV{$env_report}\n";
        }
    }

    close (MAIL);
}

sub check_email {
    # Initialize local email variable with input to subroutine.              #
    $email = $_[0];

    # If the e-mail address contains:                                        #
    if ($email =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ ||

        # the e-mail address contains an invalid syntax.  Or, if the         #
        # syntax does not match the following regular expression pattern     #
        # it fails basic syntax verification.                                #

        $email !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z0-9]+)(\]?)$/) {

        # Basic syntax requires:  one or more characters before the @ sign,  #
        # followed by an optional '[', then any number of letters, numbers,  #
        # dashes or periods (valid domain/IP characters) ending in a period  #
        # and then 2 or 3 letters (for domain suffixes) or 1 to 3 numbers    #
        # (for IP addresses).  An ending bracket is also allowed as it is    #
        # valid syntax to have an email address like: user@[255.255.255.0]   #

        # Return a false value, since the e-mail address did not pass valid  #
        # syntax.                                                            #
        return 0;
    }

    else {

        # Return a true value, e-mail verification passed.                   #
        return 1;
    }
}

sub body_attributes {
    # Check for Background Color
    if ($Config{'bgcolor'}) { print " bgcolor=\"$Config{'bgcolor'}\"" }

    # Check for Background Image
    if ($Config{'background'}) { print " background=\"$Config{'background'}\"" }

    # Check for Link Color
    if ($Config{'link_color'}) { print " link=\"$Config{'link_color'}\"" }

    # Check for Visited Link Color
    if ($Config{'vlink_color'}) { print " vlink=\"$Config{'vlink_color'}\"" }

    # Check for Active Link Color
    if ($Config{'alink_color'}) { print " alink=\"$Config{'alink_color'}\"" }

    # Check for Body Text Color
    if ($Config{'text_color'}) { print " text=\"$Config{'text_color'}\"" }
}

#############################################################################
#                                                                           #
# BSS: Send courtesy email to the visitor thanking him, etc.                #
#                                                                           #
#      Not sure if this portion of code was written by Ashley Bass or by    #
#      Donald Killen, but was taken from yForm                              #
#                                                                           #
#      Code is basically the same, just some variable name changes to be    #
#      more self explainatory.                                              #
#                                                                           #
#############################################################################
sub send_courtesy {
        if ($Config{'email'} && ($Config{'courtesy_reply'} ne "no")) {
                # mod by ago
                if ($Config{'courtesy_our_email'} ne "") {
                        $destinatario = $Config{'courtesy_our_email'};
                } else {
                        $fromEmail = &destinatario_email();

                        # Prende i destinatari:
                        @destinatari = split(/,/, $fromEmail);
                        $destinatario = $destinatari[0];
                }

                open (MAIL,"|$mailprog -f $destinatario -t");
                print MAIL "To: $Config{'email'} ($Config{'realname'} $Config{'firstname'})\n";
                print MAIL "From: $destinatario\n";

                # modifica by Ago per e-mail in
                # HTML.
                $testo_a_capo = "\n";
                if ($Config{'email_type'} eq "html") {
                        print MAIL "Content-Type: text/html; charset=UTF-8\n";
                        $testo_a_capo = "<br />\n";
                } else {
                        print MAIL "Content-Type: text/plain; charset=UTF-8\n";
                }

                if ($Config{'subject'}) {
                        print MAIL "Subject: $Config{'subject'}\n\n";
                        $subjflag = 1;
                } else {
                        print MAIL "Subject: Neikos - $date\n\n";
                        $subjflag = 0;
                }

                if ($Config{'courtesy_reply_texta'}) {
                        print MAIL "$Config{'courtesy_reply_texta'}" . $testo_a_capo;
                }

                if (($Config{'courtesy_subject_in_email'}) ne 'no') {
                        if ($subjflag) {
                                print MAIL "$Config{'subject'}" . $testo_a_capo . $testo_a_capo;
                        } else {
                                if (($Config{'lang'}) eq 'eng') {
                                        print MAIL "Neikos - Contact form" . $testo_a_capo . $testo_a_capo;
                                } else {
                                        print MAIL "Neikos - Modulo Contatto" . $testo_a_capo . $testo_a_capo;
                                }
                        }
                }

                if ($Config{'courtesy_reply_textb'}) {
                        print MAIL "$Config{'courtesy_reply_textb'}" . $testo_a_capo . $testo_a_capo;
                }

                if ($Config{'courtesy_reply_saluto'}) {
                        $salutoPersonalizzato = sprintf($Config{'courtesy_reply_saluto'}, $Config{'firstname'}, $Config{'realname'}, $date);
                        $salutoPersonalizzato =~ s//$testo_a_capo/g;

                        print MAIL $salutoPersonalizzato . $testo_a_capo . $testo_a_capo;
                } else {
                        if (($Config{'lang'}) eq 'eng') {
                                print MAIL "Dear Mr/Mrs $Config{'realname'} $Config{'firstname'}," . $testo_a_capo;
                                print MAIL "Thank you for completing our online form on $date1." . $testo_a_capo;
                                print MAIL "Your details are as follows:" . $testo_a_capo . $testo_a_capo;
                        } elsif (($Config{'lang'}) eq 'fra') {
                                print MAIL "Monsieur/Madame $Config{'realname'} $Config{'firstname'}," . $testo_a_capo;
                                print MAIL "Nous vous remercions de votre courrier du $date_fra." . $testo_a_capo;
                                print MAIL "Vos donnes sont:" . $testo_a_capo . $testo_a_capo;
                        } else  {
                                print MAIL "Gentile $Config{'realname'} $Config{'firstname'}," . $testo_a_capo;
                                print MAIL "La ringraziamo per aver compilato il nostro form in data $date." . $testo_a_capo;
                                print MAIL "I dati che ci ha fornito sono stati:" . $testo_a_capo . $testo_a_capo;
                        }
                }

                # modifica by Ago per e-mail in
            # HTML.
                if ($Config{'email_type'} eq "html") {
                        print MAIL "<hr size='1' width='100%'>";
                } else {
                        print MAIL "-" x 75 . "\n\n";
                }

                # aggiunta by Ago
                if (@Print_Config) {
                        foreach $print_config (@Print_Config) {
                                if ($Config{$print_config}) {
                                        print MAIL "    $print_config: $Config{$print_config}" . $testo_a_capo . $testo_a_capo;
                                }
                        }
                }

                # Sort alphabetically if specified:                                      #
                if ($Config{'sort'} eq 'alphabetic') {
                        foreach $field (sort keys %Form) {
                                # If the field has a value or the print blank fields option      #
                                # is turned on, print out the form field and value.              #
                                if ($Config{'print_blank_fields'} || $Form{$field} ||
                                        $Form{$field} eq '0') {
                                        print MAIL "    $field: $Form{$field}" . $testo_a_capo . $testo_a_capo;
                                }
                        }
                }

                # If a sort order is specified, sort the form fields based on that.      #
                elsif ($Config{'sort'} =~ /^order:.*,.*/) {

                        # Remove extraneous line breaks and spaces, remove the order:        #
                        # directive and split the sort fields into an array.                 #
                        $Config{'sort'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
                        $Config{'sort'} =~ s/(\s+)?\n+(\s+)?//g;
                        $Config{'sort'} =~ s/order://;
                        @sorted_fields = split(/,/, $Config{'sort'});

                        # For each sorted field, if it has a value or the print blank        #
                        # fields option is turned on print the form field and value.         #
                        foreach $sorted_field (@sorted_fields) {
                                if ($Config{'print_blank_fields'} || $Form{$sorted_field} ||
                                        $Form{$sorted_field} eq '0') {
                                        print MAIL "    $sorted_field: $Form{$sorted_field}" . $testo_a_capo . $testo_a_capo;
                                }
                        }
                }
                # Otherwise, default to the order in which the fields were sent.         #
                else {

                        # For each form field, if it has a value or the print blank          #
                        # fields option is turned on print the form field and value.         #
                        foreach $field (@Field_Order) {
                                if ($Config{'print_blank_fields'} || $Form{$field} ||
                                        $Form{$field} eq '0') {
                                        print MAIL "    $field: $Form{$field}" . $testo_a_capo . $testo_a_capo;
                                }
                        }
                }

                # modifica by Ago per e-mail in
                # HTML.
                if ($Config{'email_type'} eq "html") {
                        print MAIL "<hr size='1' width='100%'>";
                } else {
                        print MAIL "-" x 75 . "\n\n";
                }
                # fine aggiunta by Ago

                # if (($Config{'lang'}) eq 'eng') {
                #       print MAIL "Thank you!" . $testo_a_capo . $testo_a_capo;
                # } elsif (($Config{'lang'}) eq 'fra') {
                #       print MAIL "Vous recevrez dans un bref dlais une response. Merci!" . $testo_a_capo . $testo_a_capo;
                # } else {
                #       print MAIL "Ricever al pi presto una risposta. Grazie!" . $testo_a_capo . $testo_a_capo;
                # }

                if ($Config{'courtesy_who_we_are'} ne "") {
                        $courtesy_who_we_are = $Config{'courtesy_who_we_are'};
                        $courtesy_who_we_are =~ s//$testo_a_capo/g;
                        print MAIL $courtesy_who_we_are . $testo_a_capo;
                }

                if ($Config{'courtesy_who_we_are2'} ne "") {
                        $courtesy_who_we_are2 = $Config{'courtesy_who_we_are2'};
                        $courtesy_who_we_are2 =~ s//$testo_a_capo/g;
                        print MAIL $courtesy_who_we_are2 . $testo_a_capo . $testo_a_capo;
                }

                if ($Config{'courtesy_our_email'} ne "") {
                        print MAIL "$Config{'courtesy_our_email'}" . $testo_a_capo . $testo_a_capo;
                }

                if ($Config{'courtesy_our_url'} ne "") {
                        print MAIL "$Config{'courtesy_our_url'}" . $testo_a_capo . $testo_a_capo;
                }

                close (MAIL);
        }
}


#############################################################################
#                                                                           #
# BSS: Append to a Database file                                            #
#                                                                           #
#      Originally appeared in yForm written by Ashley Bass 1/29/97          #
#      Modified by Agostino Pagnozzi 10/04                                  #
#        Modified by Agostino Pagnozzi for file inclusion - 03/05                   #
#############################################################################
sub append_database {

    local($print_db,$field);

# by Ago
   if (($Config{'table'} ne "") && ($Config{'table'} ne "password")) {
          $msg_conn = "Impossibile connettersi al database.";
          $msg_stat = "Impossibile preparare la query.";

          if ($#Print_DBB_normal < 0) {

                if (@Print_Config) {
                        foreach $print_config (@Print_Config) {
                        if ($Config{$print_config}) {
                                        push @Print_DBB_normal, $print_config;
                        }
                        }
                } else {
                        while (($print_config, $valore_db) = each %CampiM) {
                                if ($Config{$print_config}) {
                                        push @Print_DBB_normal, $print_config;
                                }
                        }
                }

                # Mette in ordine alfabetico se  stato specificato.
                if ($Config{'sort'} eq 'alphabetic') {
                        foreach $field (sort keys %Form) {
                                push @Print_DBB_normal, $field;
                        }
                } elsif ($Config{'sort'} =~ /^order:.*,.*/) {
                        $Config{'sort'} =~ s/(\s+|\n)?,(\s+|\n)?/,/g;
                        $Config{'sort'} =~ s/(\s+)?\n+(\s+)?//g;
                        $Config{'sort'} =~ s/order://;
                        @sorted_fields = split(/,/, $Config{'sort'});

                        foreach $sorted_field (@sorted_fields) {
                                push @Print_DBB_normal, $sorted_field
                        }

                } else {
                        foreach $field (@Field_Order) {
                        push @Print_DBB_normal, $field;
                        }
                }

                # Elimina da questa lista i campi specificati come campi lunghi:
                foreach $bigform (@Print_DBB_big) {
                                $contatore = 0;
                                foreach $littleform (@Print_DBB_normal) {
                                        if ($bigform eq $littleform) {
                                                splice (@Print_DBB_normal,$contatore,1);
                                                $contatore = 0;
                                                last;
                                        }
                                        $contatore = $contatore + 1;
                                }
                }


                # Elimina da questa lista i campi specificati come campi file:
                foreach $fileform (@Print_DBB_file) {
                                $contatore = 0;
                                foreach $littleform (@Print_DBB_normal) {
                                        if ($fileform eq $littleform) {
                                                splice (@Print_DBB_normal,$contatore,1);
                                                $contatore = 0;
                                                last;
                                        }
                                        $contatore = $contatore + 1;
                                }
                }

                unshift @Print_DBB, @Print_DBB_normal;

                # $ll = "";
                # foreach $littleform (@Print_DBB) {
                #       $ll .= $littleform . " * ";
                # }
                # errore_database($ll);
          }

          $dbh = DBI->connect("DBI:mysql:$dbname:$dbhost;mysql_socket=/var/run/mysqld/mysqld.sock","$dbuser","$dbpass");
          if (defined $dbh) {
                #######################################################
                # Questa parte del codice crea la tabella e i campi   #
                # se questa non esiste. I nomi dei campi della ta-    #
                # bella in esame.                                     #
                #######################################################
                $sth = $dbh->prepare('SHOW TABLES') or errore_database($msg_stat);
                $sth->execute();

                $esiste_tabella = false;
                while(my $ref = $sth->fetchrow_hashref()) {
                   if ($ref->{'Tables_in_'.$dbname} eq $Config{'table'}) {
                         $esiste_tabella = true;
                   };
                }
                $sth->finish;

                if ($esiste_tabella eq false) {
                   $query = "CREATE TABLE `" . $Config{'table'} . "` (";

                   foreach $print_db (@Print_DBB_normal) {
                  $field = $print_db;
                        if ($field ne "") {
                                if ($field =~ /\s/) {
                                        $field = "`".$field."`";
                                }
                                $query .= "$field VARCHAR(60) NOT NULL default '', ";
                        }
                 }

                   foreach $print_db (@Print_DBB_big) {
                $field = $print_db;
                        if ($field ne "") {
                                if ($field =~ /\s/) {
                                        $field = "`".$field."`";
                                }
                                $query .= "$field TEXT NOT NULL default '', ";
                        }
                 }

                   foreach $print_db (@Print_DBB_file) {
                $field = $print_db;
                        if ($field ne "") {
                                if ($field =~ /\s/) {
                                        $field = "`".$field."`";
                                }
                                $query .= "$field MEDIUMBLOB NOT NULL, ";
                        }
                 }

                   $query .= "data_ora DATETIME NOT NULL default '0000-00-00 00:00:00');";

                   $sth = $dbh->prepare($query) or errore_database($msg_stat);
                   $sth->execute();
           $sth->finish;

                   ###############################################
                   # Controlla che la tabella sia stata creata,  #
                   # altrimenti non esegue alcuna operazione.    #
                   ###############################################
                   $localquery = "SELECT * FROM `" . $Config{'table'} . "` WHERE 1=1";
                   $sth = $dbh->prepare($localquery) or return "false";
                   $sth->execute() or return "false";
                   ###############################################

                   genera_password($Config{'table'}, $dbh, $Config{'table'});
                }
                ######################################################


                ######################################################
                # Questa parte del codice controlla i campi della    #
                # tabella in esame.                                                      #
                ######################################################
                $sth = $dbh->prepare('DESCRIBE '.$Config{'table'}) or errore_database($msg_stat);
                $sth->execute();

                while(my $ref = $sth->fetchrow_hashref()) {
                        if ($ref->{Type} eq "text") {
                        unshift @campi_presenti_big, $ref->{'Field'};
                        } elsif ($ref->{Type} eq "mediumblob") {
                                unshift @campi_presenti_file, $ref->{'Field'};
                        } else {
                        unshift @campi_presenti, $ref->{'Field'};
                        }
                }

                $sth->finish;

                foreach $print_db (@Print_DBB) {
                   $esiste_campo = "no";

                   foreach $campi_p (@campi_presenti) {
                if ($campi_p eq $print_db) {
                            $esiste_campo = "normale";

                            # Controlla che nn si tratti di un campo file.
                            foreach $campi_pf (@campi_presenti_file) {
                                if ($campi_pf eq $print_db) {
                                                $esiste_campo = "file";
                                        }
                            }

                            # Se si tratta di un campo normale, ma nn di un campo
                            # file...
                            if ($esiste_campo eq "normale") {
                                        foreach $print_db2 (@Print_DBB_big) {
                                                # ...E se adesso  definito come campo big, lo cambia.
                                                if ($print_db2 eq $print_db) {
                                                        $query = "ALTER TABLE `" . $Config{'table'} . "` CHANGE `" . $print_db . "` `" . $print_db . "` TEXT NOT NULL";
                                                        $sth3 = $dbh->prepare($query) or errore_database($msg_stat);
                                                        $sth3->execute();
                                        $sth3->finish;
                                                }
                                        }
                           }
                  }
                   }

                   foreach $campi_p (@campi_presenti_big) {
                 if ($campi_p eq $print_db) {
                            $esiste_campo = "big";
                         }
                   }

                   if ($esiste_campo eq "no") {
                        $tipodati = "VARCHAR(60) NOT NULL default ''";
                        foreach $print_db3 (@Print_DBB_big) {
                                if ($print_db3 eq $print_db) {
                                        $tipodati = "TEXT NOT NULL default ''";
                                }
                        }

                        foreach $print_db4 (@Print_DBB_file) {
                                if ($print_db4 eq $print_db) {
                                        $tipodati = "MEDIUMBLOB NOT NULL";
                                }
                        }

                        $field2 = $print_db;
                        # if ($field2 =~ /\s/) {
                        #       $field2 = "`".$field2."`";
                        # }

                        $query = "ALTER TABLE `" . $Config{'table'} . "` ADD `". $field2 . "` " . $tipodati . " ;";
                        $sth2 = $dbh->prepare($query) or errore_database($msg_stat);
                        $sth2->execute();
                $sth2->finish;
                   }
                }
                ######################################################


                #################################################################
                # Controlla che la tabella appena creata sia stata validata,    #
                # altrimenti non esegue alcuna operazione.                          #
                #################################################################
                $localquery = "SELECT `valida` FROM `password` WHERE `utente` = '".$Config{'table'}."'";
                $sth = $dbh->prepare($localquery) or errore_database($msg_stat);
                $sth->execute();
                $ref = $sth->fetchrow_hashref();
                if ($ref->{'valida'} ne "Y") {
                        return "false";
                }
                #################################################################


                ######################################################
                # Questa parte del codice immette nell'array @campi  #
                # I nomi dei campi della tabella in esame.               #
                ######################################################
                $sth = $dbh->prepare("DESCRIBE `" .$Config{'table'} . "`") or errore_database($msg_stat);
                $sth->execute();

                while(my $ref = $sth->fetchrow_hashref()) {
                        unshift @campi, $ref->{'Field'};
                }

        @campi = reverse @campi;
            $sth->finish;
                ######################################################

                ######## Estensioni dei file uploadabili. #########
                (@estensioni) = split(/,/,$Config{'estensioni_file'});
                ###################################################


        $query = "INSERT INTO `" . $Config{'table'} . "` (";
                $query2 = ") VALUES (";
                $querySel = "SELECT * FROM `" . $Config{'table'} . "` WHERE ";

                foreach $campo (@campi) {
                            $query .= "`$campo`,";

                                # by Ago - Vede se si tratta di un file da includere nel
                                #              database.
                                $f = 0;
                                foreach $campo_file (@Print_DBB_file) {
                                        if ($campo_file eq $campo) {
                                                $f = 1;
                                        }
                                }

                                if ($f == 1) {
                                        # Inizializza le variabili.
                                        undef $data;
                                        undef $file_name;
                                        $slen = 0;

                                        $file = $cgi->param($campo);
                                        sysseek($file, 0, SEEK_CUR);
                                while ($bytes_count = sysread($file,$buff,1024)) {
                                        $data .= $buff;
                                }

                                        # Il nome del file.
                                        $cgi->param($campo) =~ /([^\/\\]+)$/;
                                        $file_name = $1;
                                        $file_name =~ s/^\.+//;

                                        if ($file_name ne "") {
                                                (@parti) = split(/\./,$file_name);
                                                $estf = $parti[scalar(@parti)-1];

                                                if (scalar(@estensioni)>0) {
                                                        $found = 0;
                                                        foreach $est (@estensioni) {
                                                                if ($estf eq $est) {
                                                                        $found = 1;
                                                                }
                                                        }

                                                        # L'estensione del file non  corretta.
                                                        if ($found == 0) {
                                                                # rob debug - si blocca qui se non esiste allegato
                                                                &error('missing_fields');
                                                                exit;
                                                        }
                                                }

                                                # Variabile che indica la lunghezza
                                                # del file name.
                                                $slen = length($file_name);

                                                $query2 .= $dbh->quote($slen."".$file_name.$data).",";
                                                $querySel .= "`$campo`= " . $dbh->quote($slen."".$file_name.$data) . " AND ";
                                        } else {
                                                $query2 .= "'',";
                                                $querySel .= "`$campo`= '' AND ";
                                        }
                                } elsif ($Config{$campo}) {
                                        $field = $Config{$campo};
                                $field =~ s/\r\n/ /gs;
                        $query2 .= "'" . quotemeta($field) . "',";
                                        $querySel .= "`$campo`= '" . quotemeta($field) . "' AND ";
                } elsif ($Form{$campo}) {
                                        $field = $Form{$campo};
                                $field =~ s/\r\n/ /gs;
                        $query2 .= "'" . quotemeta($field) . "',";
                                        $querySel .= "`$campo`= '" . quotemeta($field) . "' AND ";
                                } elsif ($campo eq "data_ora") {
                                        &get_date;
                                        $query2 .= "'$date3 $time',";

                                        $diff = 5*60; # millisecondi in 5 minuti.
                                        $querySel .= "`data_ora` >= FROM_UNIXTIME(UNIX_TIMESTAMP()-" . $diff . ") AND ";
                                } else {
                                        $query2 .=  "'',";
                                        $querySel .= "`$campo`= '' AND ";
                                }
                }

        if (substr($query,-1,1) eq ",") {$query = substr($query, 0, -1)} ;
        if (substr($query2,-1,1) eq ",") {$query2 = substr($query2, 0, -1)} ;
        $query .= $query2 . ")";
                $querySel .= " 1=1";

                # Controlla che non ci siamo state inserimenti
                # uguali negli ultimi 5 minuti.
                $sth2 = $dbh->prepare($querySel) or errore_database($msg_stat);
                $sth2->execute() or errore_database($msg_stat);
                $contRow = 0;
                while (my $stt = $sth2->fetchrow_hashref()) {
                        $contRow++;
                }
                $sth2->finish;

                #errore_database($contRow);

                if ($contRow > 0) {
                        &return_html;
                        exit;
                }


                # errore_database($query);

                # Inserisce la scheda nel db.
                $sth2 = $dbh->prepare($query) or errore_database($msg_stat);
                $sth2->execute() or errore_database($msg_stat);
                $sth2->finish;

                #######################################################
                # Questa parte del codice si occupa delle statistiche #
                # relative ai form di contatto.                               #
                #######################################################
                if ($Config{'email'}  =~  /\@neikos.it/) {
                } else {
                        $query = "SHOW COLUMNS FROM `stats` LIKE '" . $datentmk . "'";
                        $sth2 = $dbh->prepare($query) or errore_database($msg_stat);
                        $sth2->execute();
                        my $ref = $sth2->fetchrow_hashref();
                        if ($ref->{'Field'} eq "") {
                                #$query2 = "ALTER TABLE `stats` ADD `". $datentmk . "` INT(3) NOT NULL default ''";
                                $query2 = "ALTER TABLE `stats` ADD `". $datentmk . "` INT(3) DEFAULT '0' NOT NULL";
                                $sth3 = $dbh->prepare($query2) or errore_database($msg_stat);
                                $sth3->execute();
                                $sth3->finish;
                        }
                        $sth2->finish;

                        $query = "SELECT * FROM `stats` WHERE tabella='" . $Config{'table'} . "' LIMIT 1";
                        $sth2 = $dbh->prepare($query) or errore_database($msg_stat);
                        $sth2->execute();
                        my $ref = $sth2->fetchrow_hashref();
                        if ($ref->{'tabella'} eq "") {
                                $query3 = "INSERT INTO `stats` SET `tabella` = '" . $Config{'table'} . "', `" . $datentmk . "` = 1";
                        } else {
                                $query3 = "UPDATE `stats` SET `" . $datentmk . "` = `" . $datentmk . "` + 1 WHERE tabella='" . $Config{'table'} . "'";
                        }
                        $sth2->finish;

                        $sth2 = $dbh->prepare($query3) or errore_database($msg_stat);
                        $sth2->execute();
                        $sth2->finish;
                }
                #######################################################
        } else {
        errore_database($msg_conn);
        }

    $dbh->disconnect;

        #########################################
        # Accede al database delle newsletter!! #
        #########################################
        $dbh2 = DBI->connect("DBI:mysql:$dbnamenews:$dbhost;mysql_socket=/var/run/mysqld/mysqld.sock","$dbusernews","$dbpassnews");

        if (defined $dbh2) {
                $sth = $dbh2->prepare("SELECT group_id FROM `newsletter_group` WHERE `name` = '" . $Config{'table'} . "'") or errore_database($msg_stat);
                $sth->execute();
                $group_id = "";
                while(my $ref = $sth->fetchrow_hashref()) {
                        $group_id = $ref->{'group_id'};
                }
                $sth->finish;

                if ($group_id eq "") {
                        # Aggiunge un gruppo alla newsletter.

                        $query = "INSERT INTO `newsletter_group` (`group_id`,`name`,`showgroup`) VALUES ('', '" . $Config{'table'} . "', 'No')";
                        $sth = $dbh2->prepare($query) or errore_database($msg_stat);
                        $sth->execute();
                        $sth->finish;

                        $sth2 = $dbh2->prepare("SELECT group_id FROM `newsletter_group` WHERE `name` = '" . $Config{'table'} . "'") or errore_database($msg_stat);
                        $sth2->execute();
                        while(my $ref = $sth2->fetchrow_hashref()) {
                                $group_id = $ref->{'group_id'};
                        }
                        $sth2->finish;
                }


                # Aggiunge un nuovo contatto al gruppo.
                if ($Config{'email'} ne "") {
                        if ($Config{'firstname'} ne "") {
                                $nomecognome = $Config{'firstname'} . " " . $Config{'realname'};
                        } else {
                                $nomecognome = $Config{'realname'};
                        }

                        $sth = $dbh2->prepare("SELECT t1.email FROM newsletter_subscriber AS t1, newsletter_subscribe AS t2 WHERE t1.email = '" . $Config{'email'} . "' AND t1.subscriber_id = t2.subscriber_id AND t2.group_id = '" . $group_id . "' AND t1.firstname = '" . quotemeta($nomecognome) . "'") or errore_database($msg_stat);
                        $sth->execute();
                        $cont = 0;
                        while(my $ref = $sth->fetchrow_hashref()) {
                                $cont++;
                        }
                        $sth->finish;

                        # aggiunge un iscritto alla newsletter del gruppo.
                        if ($cont == 0) {
                                $query = "INSERT INTO `newsletter_subscriber` ( `subscriber_id` , `firstname` , `lastname` , `company` , `position` , `email` , `lettertype` , `status` ) VALUES ('" . $subscriber_id . "', '";
                                $query .= quotemeta($nomecognome) . "', '', '', '', '" . $Config{'email'} . "', 'HTML', 'Active')";
                                $sth = $dbh2->prepare($query) or errore_database($msg_stat);
                                $sth->execute();
                                $sth->finish;

                                $query = "SELECT * FROM `newsletter_subscriber` WHERE `email` = '" . $Config{'email'} . "'";
                                $sth = $dbh2->prepare($query) or errore_database($msg_stat);
                                $sth->execute();
                                while(my $ref = $sth->fetchrow_hashref()) {
                                        $subscriber_id = $ref->{'subscriber_id'};
                                }
                                $sth->finish;

                                $query = "INSERT INTO `newsletter_subscribe` ( `group_id`, `subscriber_id` ) VALUES ('" . $group_id . "', '" . $subscriber_id . "')";
                                $sth = $dbh2->prepare($query) or errore_database($msg_stat);
                                $sth->execute();
                                $sth->finish;
                        }
                }
        } else {
                errore_database($msg_conn);
        }

        $dbh2->disconnect;


    } # se esiste 'table'


    if ($Config{'append_db'})  {
        if (-w $Config{'append_db'}) {
                        #mod rob
                flock("$Config{'append_db'}", 8);
                        # &lockit ("$Config{'append_db'}.lock");

                        open (DATABASE, ">>$Config{'append_db'}");
                        print DATABASE "$Config{'db_delimiter'}";
                        print DATABASE "$date2$Config{'db_delimiter'}";
                print DATABASE "$time$Config{'db_delimiter'}";

                foreach $print_db (@Print_DB) {
                        if ($Config{$print_db}) {
                                $field = $Config{$print_db};
                                        $field =~ s/\r\n/ /gs;
                                print DATABASE "$field";
                        }
                        if ($Form{$print_db}) {
                                $field = $Form{$print_db};
                                        $field =~ s/\r\n/ /gs;
                                print DATABASE "$field";
                        };

                                print DATABASE "$Config{'db_delimiter'}";
                };

                print DATABASE "\n";
                close (DATABASE);

                        #mod rob
                flock("$Config{'append_db'}", 8);
                        # &unlockit ("$Config{'append_db'}.lock");
                }
   }

   return "true";
}


# by Ago

sub errore_database {
        local ($msg_error) = @_;
        print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Error database - Access Denied</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size="+2">Error Database</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td><br>Errore nell'accesso al database.<br>$msg_error <br><br>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)

        exit;
}



sub lockit
  {
  local ($lock_file) = @_;
  local ($endtime);
  $endtime = 20;
  $endtime = time + $endtime;

  while (-e $lock_file && time < $endtime)
    {
    sleep(1);
    }

  open(LOCK_FILE, ">$lock_file") || &file_open_error ("$lock_file",
                                                      "Lock File Routine",
                                                      __FILE__, __LINE__);

# flock(LOCK_FILE, 2); # 2 exclusively locks the file
  }

#######################################################################
sub unlockit
  {
  local ($lock_file) = @_;

# flock(LOCK_FILE, 8); # 8 unlocks the file

  close(LOCK_FILE) ;
  unlink($lock_file) ;
  print "$lock_file"; exit;
  }

#######################################################################
sub file_open_error
  {
  local ($bad_file, $script_section, $this_file, $line_number) = @_;
  print "Content-type: text/html\n\nI was not able to access $bad_file.";
#  &CgiDie ("I am sorry, but I was not able to access $bad_file.")
  }



sub error {
    # Localize variables and assign subroutine input.                        #
    local($error,@error_fields) = @_;
    local($host,$missing_field,$missing_field_list);


    if ($error eq 'bad_referer') {
        if ($ENV{'HTTP_REFERER'} =~ m|^https?://([\w\.]+)|i) {
            $host = $1;
            print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Accesso non autorizzato!</title>
 </head>
<body>

<p align="center"><img border="0" src="http://www.neikos.it/img/h1_logo.gif" style="background:black"></p>
<p align="center"><font color="#113166" size="5" face="Arial"><b>ACCESSO NON
AUTORIZZATO!</b></font></p>
<p align="center"><b><font color="#113166" face="Arial" size="3">Questo software e' di esclusiva
proprieta' della NEIKOS snc</font></b></p>
<p align="center"><b><font color="#113166" face="Arial" size="3"> e ne e' vietato qualsiasi utilizzo non autorizzato.</font></b></p>
<p align="center">&nbsp;</p>
<p align="center"><b><font color="#113166" face="Arial" size="3">Questo
tentativo di utilizzo dall' URL: <tt>$ENV{'HTTP_REFERER'}</tt></font></b></p>
<p align="center"><b><font color="#113166" face="Arial" size="3">e' stato
registrato ed inoltrato all'ufficio legale.</font></b></p>

</body>

</html>
(END ERROR HTML)
               } else {
            print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Accesso non autorizzato!</title>
 </head>
 <body>

<p align="center"><img border="0" src="http://www.neikos.it/img/h1_logo.gif" style="background:black"></p>
<p align="center"><font color="#113166" size="5" face="Arial"><b>ACCESSO NON
AUTORIZZATO!</b></font></p>
<p align="center"><b><font color="#113166" face="Arial" size="3">Questo software e' di esclusiva
proprieta' della NEIKOS snc</font></b></p>
<p align="center"><b><font color="#113166" face="Arial" size="3"> e ne e' vietato qualsiasi utilizzo non autorizzato.</font></b></p>
<p align="center">&nbsp;</p>
<p align="center"><b><font color="#113166" face="Arial" size="3">Questo
tentativo di utilizzo dall' URL: <tt>$ENV{'HTTP_REFERER'}</tt></font></b></p>
<p align="center"><b><font color="#113166" face="Arial" size="3">e' stato
registrato ed inoltrato all'ufficio legale.</font></b></p>

</body></html>
(END ERROR HTML)
        }
    }

    elsif ($error eq 'request_method') {
            print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Error: Request Method</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: Request Method</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>The Request Method of the Form you submitted did not match
     either <tt>GET</tt> or <tt>POST</tt>.  Please check the form and make sure the
     <tt>method=</tt> statement is in upper case and matches <tt>GET</tt> or <tt>POST</tt>.<p>

     <center><font size=-1>
      <a href="http://www.worldwidemart.com/scripts/formmail.shtml">FormMail</a> V1.9 &copy; 1995 - 2001  Matt Wright<br>
      A Free Product of <a href="http://www.worldwidemart.com/scripts/">Matt's Script Archive, Inc.</a>
     </font></center>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
    }

    elsif ($error eq 'no_recipient') {
            print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Error: Bad/No Recipient</title>
 </head>
 <body bgcolor=#FFFFFF text=#000000>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: Bad/No Recipient</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>There was no recipient or an invalid recipient specified in the data sent to FormMail.  Please
     make sure you have filled in the <tt>recipient</tt> form field with an e-mail
     address that has been configured in <tt>\@recipients</tt>.  More information on filling in <tt>recipient</tt> form fields and variables can be
     found in the README file.<hr size=1>

     <center><font size=-1>
      <a href="http://www.worldwidemart.com/scripts/formmail.shtml">FormMail</a> V1.9 &copy; 1995 - 2001  Matt Wright<br>
      A Free Product of <a href="http://www.worldwidemart.com/scripts/">Matt's Script Archive, Inc.</a>
     </font></center>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
    }

    elsif ($error eq 'missing_fields') {
        if ($Config{'missing_fields_redirect'}) {
            print "Location: $Config{'missing_fields_redirect'}\n\n";
        }
        else {
            foreach $missing_field (@error_fields) {
                $missing_field_list .= "      <li>$missing_field\n";
            }

            print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Error: Blank Fields</title>
 </head>
  <center>
   <table border=0 width=600 bgcolor=#9C9C9C>
    <tr><th><font size=+2>Error: Blank Fields</font></th></tr>
   </table>
   <table border=0 width=600 bgcolor=#CFCFCF>
    <tr><td>The following fields were left blank in your submission form:<p>
     <ul>
$missing_field_list
     </ul><br>

     These fields must be filled in before you can successfully submit the form.<p>
     Please use your browser's back button to return to the form and try again.<hr size=1>
     <center><font size=-1>
     </font></center>
    </td></tr>
   </table>
  </center>
 </body>
</html>
(END ERROR HTML)
        }
    } elsif ($error eq 'html_tag') {
           print <<"(END ERROR HTML)";
Content-type: text/html

<html>
 <head>
  <title>Non  possibile utilizzare codice HTML nei FORM!</title>
 </head>
<body>

<p align="center"><img border="0" src="http://www.neikos.it/img/h1_logo.gif" style="background:black"></p>
<p align="center"><font color="#113166" size="5" face="Arial"><b>NON E' POSSIBILE UTILIZZARE CODICE HTML NEI FORM!</b></font></p>
<p align="center"><font color="#113166" size="2" face="Arial"><a href="javascript:history.back();">Clicca qui</a> per tornare indietro!</font></p>

</body>

</html>
(END ERROR HTML)
    }

    exit;
}




##############################################################
# Nuova sub by Ago.
# Questa sub genera una nuova password a partire da un nome
# utente.
# I parametri passati a questa sub sono:
#    1. il nome utente;
#    2. la connessione al database dove memorizzare
#       nome utente e password.
##############################################################
sub genera_password() {
        local ($nome_utente) = @_[0];
        local ($dbh) = @_[1];
        local ($tabella) = @_[2];

        if ((defined($dbh)) && ($nome_utente ne "")) {

                $parte1 = "";
                $parte2 = "";

                for ($a=0;$a<length($nome_utente);$a++) {
                        $b = substr($nome_utente,$a,1);
                        if ($b =~ /[ a e o u ]/) {
                                $parte2 .= $b;
                        } elsif ($b =~ /[b c d f g h m n p q r s t u v w z]/) {
                        $parte1 .= $b;
                        }
                }

                $password = $parte1 . $parte2;
                if (length($password)>4) {
                        $password = substr($password,0,4);
                } elsif (length($password)<4) {
                        while (length($password)<4) {
                                $nuovo_car = chr(97 + int(rand "25"));
                                if ($nuovo_car =~ /[^ i l ]/ ) {
                                   $password .= $nuovo_car;
                                }
                        }
                }

                $controllo = 0;
                $contatore = 0;
                $max = 10000;   # numero massimo di prove da parte del sottostante ciclo
                                        # per creare una password non presente gi nel database.
                $passerrore = "password";       # password assegnata in caso di mancata assegna-
                                                        # zione della password random da parte del software.


                while (($controllo == 0) && ($contatore<$max)) {
                        $a = int(rand "9999");

                        $b = "0000". "$a";
                        $b = substr($b, , -4);
                        $b =~ s/1/2/;

                        # $localquery = "SELECT utente, pwd, tabella FROM `password` WHERE `utente` = '" . $nome_utente . "' AND `pwd` = '" . $password . $b . "'";
                        $localquery = "SELECT pwd FROM `password` WHERE `pwd` = '" . $password . $b . "'";
                        $sth3 = $dbh->prepare($localquery) or errore_database($msg_stat);
                        $sth3->execute();

                        $cont = 0;
                        while (my $ref = $sth3->fetchrow_hashref()) {
                                $cont++;
                        }

                        if ($cont == 0) {
                                $localquery = "INSERT INTO `password` (`utente`, `pwd`, `tabella`, `referer`, `valida`) VALUES ('" . $nome_utente . "','" . $password . $b . "','" . $tabella . "', '', 'N')";
                                $realpassword = $password . $b;
                                $sth3 = $dbh->prepare($localquery) or errore_database($msg_stat);
                                $sth3->execute();
                                $sth3->finish;
                                $controllo = 1;
                        } else {
                                $controllo = 0;
                        }

                        $sth3->finish;
                        $contatore++;
                }


                # In questo caso si  verificato che il software in '$max' tentativi random, non  riuscito a creare
                # una password che non sia gi presente nel database!!!
                if ($contatore>=$max) {
                        $localquery = "INSERT INTO `password` (`utente`, `pwd`, `tabella`, `referer`, `valida`) VALUES ('" . $nome_utente . "','" . $passerrore . "','" . $tabella . "', '', 'N')";
                        $realpassword = $passerrore;
                        $sth3 = $dbh->prepare($localquery) or errore_database($msg_stat);
                        $sth3->execute();
                        $sth3->finish;
                }

                ########################################################################
                # Invia l'e-mail all'amministratore del sistema contenente nome utente #
                # e password appena creati.                                                                                #
                ########################################################################
                if ((($Config{'recipient'} =~ /@/) == false) && ($Config{'recipientdomain'} ne "")) {
                $destinatario = $Config{'recipient'} . '@' . $Config{'recipientdomain'};
        } else {
                $destinatario = $Config{'recipient'};
        }

                open(MAIL2,"|$mailprog -f $destinatario -t");
        print MAIL2 "To: $emailam\n";
                print MAIL2 "Bcc: a.pagnozzi\@neikos.it\n";
                print MAIL2 "From: $destinatario ($Config{'table'})\n";
                print MAIL2 "Subject: Modulo contatto - Nome utente e password\n\n";
                print MAIL2 "Modulo contatto - Nome utente e password\n\n";
                print MAIL2 "-" x 75 . "\n\n";
                print MAIL2 "Una nuova coppia nome utente - password  stata creata nel database\ndel 'dbmail'.\nI parametri sono:\n\n";
                print MAIL2 " " x 20 . "NOME UTENTE: ". $nome_utente . "\n";
                print MAIL2 " " x 20 . "PASSWORD:             " . $realpassword . "\n";
                print MAIL2 " " x 20 . "TABELLA:           " . $tabella . "\n\n";
        print MAIL2 "-" x 75 . "\n\n";
                close (MAIL2);
                #######################################################################

        }
}
##############################################################

sub destinatario_email {
                $destinatario = "";
                $recipient = "";

                # modifica by Ago #
                if ((($Config{'recipient'} =~ /@/) == false) && ($Config{'recipientdomain'} ne "")) {
                        (@emails) = split(/,/,$Config{'recipient'});
                        (@domains) = split(/,/,$Config{'recipientdomain'});

                        for ($a=0;$a<=$#emails;$a++) {
                                if ($domains[$a] eq "") {
                                        $domains[$a] = $domains[0];
                                }

                                # Elimina gli spazi bianchi
                                $emails[$a] =~ s/\s//g;
                                $domains[$a] =~ s/\s//g;

                                $dest[$a] = $emails[$a] . "@" . $domains[$a];
                        }

                        $destinatario = join(',',@dest);
                } else {
                        $destinatario = $Config{'recipient'};
                }


                $if = $Config{'if'};

                if ($if ne "") {
                        (@recipients) = split(/,/,$destinatario);

                        $cont = 0;
                        foreach $condizione (split(/:/,$if)) {
                                ($cse, $cuguale, $cemailnum) = split(//, $condizione, 3);

                                # Elimina gli spazi bianchi.
                                $cse =~ s/\s//g;
                                $cuguale =~ s/\s//g;
                                $cemailnum =~ s/\s//g;

                                if (eval("$Form{$cse}") eq $cuguale) {
                                        if ($recipients[$cemailnum] ne "") {
                                                if ($cont > 0) {
                                                        $recipient .= ",";
                                                }
                                                $cont++;

                                                $recipient .= $recipients[$cemailnum];
                                        }
                                }
                        }

                        # Se le combinazioni possibile non segnalano nemmeno un indirizzo
                        # valido, allora l'email  mandata a tutti.
                        if ($recipient ne "") {
                                $destinatario = $recipient;
                        }
                }

                # if ((($Config{'recipient'} =~ /@/) == false) && ($Config{'recipientdomain'} ne "")) {
                #       $destinatario = $Config{'recipient'} . '@' . $Config{'recipientdomain'};
                # } else {
                #       $destinatario = $Config{'recipient'};
                # }
                ###################

                return($destinatario);
}



### Metodo per encryptare gli allegati delle email - By Ago ###
sub encode_base64 ($;$){
        my $res = "";
        my $eol = $_[1];
        $eol = "\n" unless defined $eol;
        pos($_[0]) = 0; # ensure start at the beginning
        while ($_[0] =~ /(.{1,45})/gs) {
                $res .= substr(pack('u', $1), 1);
                chop($res);
        }
        $res =~ tr|` -_|AA-Za-z0-9+/|; # `# help emacs
        # fix padding at the end
        my $padding = (3 - length($_[0]) % 3) % 3;
        $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
        # break encoded string into lines of no more than 76 characters each
        if (length $eol) {
                $res =~ s/(.{1,76})/$1$eol/g;
        }
        $res;
}
#### fine by Ago ####

